package com.elitesland.cbpl.rosefinch.queue;

import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.domain.TaskRequestParam;

/**
 * 任务队列
 *
 * @author eric.hao
 * @since 2024/06/24
 */
public interface QueueHandlerService {

    /**
     * 任务发布
     *
     * @param instance     实例日志
     * @param requestParam 任务调度参数
     */
    void publish(RosefinchInstanceSaveParamVO instance, TaskRequestParam requestParam);


    /**
     * 终止任务实例
     *
     * @param instanceKey 实例ID
     * @return 是否终止成功
     */
    boolean stopImmediately(String instanceKey);
}
