package com.elitesland.cbpl.rosefinch.queue.consumer;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.rosefinch.queue.topic.QueueTopic;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import org.slf4j.MDC;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

import java.util.Map;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.ROSEFINCH_QUEUE_STRATEGY;

/**
 * @author eric.hao
 * @since 2024/09/29
 */
public abstract class QueueConsumer<T extends QueueTopic> {

    /**
     * 消费处理
     */
    public void consumer(T message) {
        setContextMap(message.getParentMdc());
        // 租户不隔离
        if (RosefinchUtil.noTenant()) {
            executor(message).run();
        }
        // 按租户隔离
        else {
            TenantSpiUtil.setCurrentTenant(message.getTenantCode());
            executor(message).run();
            TenantSpiUtil.resetCurrentTenant();
        }
    }

    /**
     * 任务执行
     */
    private Runnable executor(T message) {
        return () -> {
            try {
                QueueProxy handler = SpringUtil.getBean(QueueProxy.class);
                handler.execute(message.getInstance(), message.getRequestParam());
            } catch (Exception e) {
                LogUtil.error(message.getTaskCode(), null,
                        "[ROSEFINCH][" + ROSEFINCH_QUEUE_STRATEGY.toUpperCase() + "] 处理任务异常：",
                        null, e, null
                );
            }
        };
    }

    /**
     * MDC上下文，一般是`traceId`场景
     */
    private void setContextMap(final Map<String, String> context) {
        if (context == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(context);
        }
    }
}