package com.elitesland.cbpl.rosefinch.queue.producer;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.domain.TaskRequestParam;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * @author eric.hao
 * @since 2024/06/24
 */
@Slf4j
@RequiredArgsConstructor
public class DefaultQueueProducer implements QueueHandlerService {

    /**
     * 同步执行
     */
    @Override
    public void publish(RosefinchInstanceSaveParamVO instance, TaskRequestParam requestParam) {
        try {
            LogUtil.info(instance.getTaskCode(), null, "[ROSEFINCH][DEFAULT] 任务发布: ", null, null);
            QueueProxy handler = SpringUtil.getBean(QueueProxy.class);
            handler.execute(instance, requestParam);
        } catch (NoSuchBeanDefinitionException e) {
            LogUtil.error(instance.getTaskCode(), null,
                    "[ROSEFINCH][DEFAULT] 任务(" + instance.getTaskCode() + ") 处理异常：",
                    null, e, null
            );
        }
    }

    @Override
    public boolean stopImmediately(String instanceKey) {
        return false;
    }
}
