package com.elitesland.cbpl.rosefinch.queue.topic;

import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.domain.TaskRequestParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/09/29
 */
@Data
public class QueueTopic implements Serializable {

    private static final long serialVersionUID = 6270373503088347865L;

    /**
     * Saves the MDC value of the current thread
     */
    private Map<String, String> parentMdc;

    /**
     * 任务实例
     */
    private RosefinchInstanceSaveParamVO instance;

    /**
     * 任务调度参数
     */
    private TaskRequestParam requestParam;

    /**
     * 租户编码【可能为空】
     */
    private String tenantCode;

    /**
     * 任务编码
     */
    @JsonIgnore
    public String getTaskCode() {
        return instance.getTaskCode();
    }
}
