package com.elitesland.cbpl.rosefinch.config;

import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.proxy.ProducerProxyService;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.queue.producer.SyncQueueProducer;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.dromara.dynamictp.core.spring.EnableDynamicTp;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.ROSEFINCH_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/08/05
 */
@Slf4j
@EnableDynamicTp
@Configuration
@EnableConfigurationProperties(RosefinchProperties.class)
@ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class RosefinchAutoConfiguration {

    /**
     * 任务队列的发布与终止接口
     */
    @Bean
    @ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "queue-strategy", havingValue = "default", matchIfMissing = true)
    public QueueHandlerService syncQueueProducer() {
        logger.info("[ROSEFINCH] Registry SyncQueueProducer.");
        return new SyncQueueProducer();
    }

    /**
     * 任务调度的工具类
     */
    @Bean
    @ConditionalOnClass({RosefinchInstanceService.class})
    public ProducerProxyService queueProxyService(RosefinchInstanceService instanceService, QueueHandlerService handlerService) {
        logger.info("[ROSEFINCH] Registry ProducerProxy.");
        return new ProducerProxyService(instanceService, handlerService);
    }
}
