package com.elitesland.cbpl.rosefinch.data.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * 任务配置表
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_rosefinch_config")
@org.hibernate.annotations.Table(appliesTo = "sys_rosefinch_config", comment = "任务配置表")
@ApiModel("任务配置表")
public class RosefinchConfigDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 5711390785238465669L;

    /**
     * 应用名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "应用名称")
    @Column(name = "app_name", nullable = true, length = 64)
    private String appName;

    /**
     * 应用编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "应用编码")
    @Column(name = "app_code", nullable = true, length = 64)
    private String appCode;

    /**
     * 分组标签
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "分组标签")
    @Column(name = "task_tag", nullable = true, length = 64)
    private String taskTag;

    /**
     * 定时任务名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务名称")
    @Column(name = "task_name", nullable = true, length = 64)
    private String taskName;

    /**
     * 定时任务编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务编码")
    @Column(name = "task_code", nullable = true, length = 64)
    private String taskCode;

    /**
     * 任务类型：1常规、2进度条、3导出、4反射
     * nullable : true
     * default  : 4
     */
    @ApiModelProperty(value = "任务类型")
    @Column(name = "task_type", nullable = true, length = 11)
    private Integer taskType;

    /**
     * 类名
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "类名")
    @Column(name = "class_name", nullable = true, length = 256)
    private String className;

    /**
     * 方法名
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "方法名")
    @Column(name = "method", nullable = true, length = 256)
    private String method;

    /**
     * 方法固定参数(JSON字符串)
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "方法固定参数(JSON字符串)")
    @Column(name = "method_args", nullable = true)
    private String methodArgs;

    /**
     * 状态：0禁用；1启用；
     * nullable : true
     * default  : 0
     */
    @ApiModelProperty(value = "状态：0禁用；1启用；")
    @Column(name = "status", nullable = true, length = 11)
    private Integer status;

    /**
     * 定时任务是否开启：0否；1是；
     * nullable : true
     * default  : 0
     */
    @ApiModelProperty(value = "定时任务是否开启")
    @Column(name = "schedule_flag", nullable = true, length = 11)
    private Integer scheduleFlag;

    /**
     * 告警推送是否开启：0否；1是；
     * nullable : true
     * default  : 0
     */
    @ApiModelProperty(value = "告警推送是否开启")
    @Column(name = "warn_flag", nullable = true, length = 11)
    private Integer warnFlag;

    /**
     * 实例删除策略
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "实例删除策略")
    @Column(name = "deletion_strategy", nullable = true, length = 2)
    private String deletionStrategy;
}
