package com.elitesland.cbpl.rosefinch.data.vo.param;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 任务配置表
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Data
@ApiModel("任务配置表")
public class RosefinchConfigSaveParamVO {

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "分组标签")
    private String taskTag;

    @ApiModelProperty(value = "定时任务名称")
    private String taskName;

    @ApiModelProperty(value = "定时任务编码")
    private String taskCode;

    /**
     * {@link RosefinchType}
     */
    @ApiModelProperty(value = "任务类型")
    private Integer taskType;

    @ApiModelProperty(value = "类名")
    private String className;

    @ApiModelProperty(value = "方法名")
    private String method;

    @ApiModelProperty(value = "方法固定参数(JSON字符串)")
    private String methodArgs;

    @ApiModelProperty(value = "状态：0禁用；1启用；")
    private Integer status;

    @ApiModelProperty(value = "定时任务是否开启")
    private Integer scheduleFlag;

    @ApiModelProperty(value = "告警推送是否开启")
    private Integer warnFlag;

    @ApiModelProperty(value = "实例删除策略")
    private String deletionStrategy;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "自定义字段(JSON字符串)")
    private String customFields;

    public boolean isNew() {
        return ObjectUtil.isNull(id);
    }
}
