package com.elitesland.cbpl.rosefinch.proxy;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.rosefinch.client.register.RosefinchProxy;
import com.elitesland.cbpl.rosefinch.client.register.dto.RosefinchSaveParamDTO;
import com.elitesland.cbpl.rosefinch.data.convert.RosefinchConfigConvert;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchConfigRepo;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cbpl.unicom.domain.InvokeTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/08/09
 */
@Slf4j
@UnicomTag(InvokeTag.TAG_GENERAL)
@RequiredArgsConstructor
public class RosefinchProxyService implements RosefinchProxy {

    private final RosefinchConfigRepo rosefinchConfigRepo;
    private final RosefinchConfigService rosefinchConfigService;

    @Override
    public Long create(RosefinchSaveParamDTO saveParamDTO) {
        // TODO 新增检查
        Optional<RosefinchConfigDO> rosefinchConfigDO = rosefinchConfigRepo.findByTaskCode(saveParamDTO.getTaskCode());
        if (rosefinchConfigDO.isPresent()) {
            return rosefinchConfigDO.get().getId();
        }
        var saveParam = RosefinchConfigConvert.INSTANCE.toSaveParam(saveParamDTO);
        return rosefinchConfigService.save(saveParam);
    }

    @Override
    public Long update(RosefinchSaveParamDTO saveParamDTO) {
        // TODO 修改检查
        Optional<RosefinchConfigDO> rosefinchConfigDO = rosefinchConfigRepo.findByTaskCode(saveParamDTO.getTaskCode());
        if (rosefinchConfigDO.isPresent()) {
            return rosefinchConfigDO.get().getId();
        }
        var saveParam = RosefinchConfigConvert.INSTANCE.toSaveParam(saveParamDTO);
        return rosefinchConfigService.save(saveParam);
    }

    @Override
    public boolean delete(long taskId) {
        try {
            rosefinchConfigService.delete(ListUtil.of(taskId));
        } catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }
}
