package com.elitesland.cbpl.rosefinch.queue;

import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;

/**
 * 任务队列
 *
 * @author eric.hao
 * @since 2024/06/24
 */
public interface QueueHandlerService {

    /**
     * 任务发布
     *
     * @param payload  消息报文
     */
    void publish(TaskMessage<?> payload);


    /**
     * 终止任务实例
     *
     * @param instanceKey 实例ID
     * @return 是否终止成功
     */
    boolean stopImmediately(String instanceKey);
}
