/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.proxy;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.rosefinch.client.register.RosefinchProxy;
import com.elitesland.cbpl.rosefinch.client.register.dto.RosefinchSaveParamDTO;
import com.elitesland.cbpl.rosefinch.data.convert.RosefinchConfigConvert;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchConfigRepo;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnicomTag(value="GENERAL")
public class RosefinchProxyService
implements RosefinchProxy {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchProxyService.class);
    private final RosefinchConfigRepo rosefinchConfigRepo;
    private final RosefinchConfigService rosefinchConfigService;

    public Long create(RosefinchSaveParamDTO saveParamDTO) {
        Optional<RosefinchConfigDO> rosefinchConfigDO = this.rosefinchConfigRepo.findByTaskCode(saveParamDTO.getTaskCode());
        if (rosefinchConfigDO.isPresent()) {
            return rosefinchConfigDO.get().getId();
        }
        RosefinchConfigSaveParamVO saveParam = RosefinchConfigConvert.INSTANCE.toSaveParam(saveParamDTO);
        return this.rosefinchConfigService.save(saveParam);
    }

    public Long update(RosefinchSaveParamDTO saveParamDTO) {
        Optional<RosefinchConfigDO> rosefinchConfigDO = this.rosefinchConfigRepo.findByTaskCode(saveParamDTO.getTaskCode());
        if (rosefinchConfigDO.isPresent()) {
            return rosefinchConfigDO.get().getId();
        }
        RosefinchConfigSaveParamVO saveParam = RosefinchConfigConvert.INSTANCE.toSaveParam(saveParamDTO);
        return this.rosefinchConfigService.save(saveParam);
    }

    public boolean delete(long taskId) {
        try {
            this.rosefinchConfigService.delete(ListUtil.of((Object[])new Long[]{taskId}));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public RosefinchProxyService(RosefinchConfigRepo rosefinchConfigRepo, RosefinchConfigService rosefinchConfigService) {
        this.rosefinchConfigRepo = rosefinchConfigRepo;
        this.rosefinchConfigService = rosefinchConfigService;
    }
}

