package com.elitesland.cbpl.rosefinch.data.controller;

import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigPagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigPagingVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/06
 */
@Slf4j
@Api(tags = "任务配置表")
@RestController
@RequestMapping("/rosefinch/config")
@AllArgsConstructor
public class RosefinchConfigController {

    private final RosefinchConfigService rosefinchConfigService;

    @ApiOperation(value = "分页查询")
    @PostMapping(value = "/list")
    public HttpResult<PagingVO<RosefinchConfigPagingVO>> list(@RequestBody RosefinchConfigPagingParamVO query) {
        logger.info("[Rosefinch][Config] query paging param = {}", query);
        return HttpResult.ok(rosefinchConfigService.rosefinchConfigPageBy(query));
    }

    @ApiOperation(value = "明细查询")
    @GetMapping(value = "/detail/{id}")
    public HttpResult<RosefinchConfigDetailVO> detail(@PathVariable("id") Long id) {
        logger.info("[Rosefinch][Config] query detail by id = {}", id);
        return HttpResult.ok(rosefinchConfigService.rosefinchConfigById(id));
    }

    @ApiOperation(value = "新增或修改")
    @PostMapping(value = "/save")
    public HttpResult<Long> save(@RequestBody RosefinchConfigSaveParamVO saveParam) {
        logger.info("[Rosefinch][Config] create/update record, saveParam = {}", saveParam);
        return HttpResult.ok(rosefinchConfigService.save(saveParam));
    }

    @ApiOperation(value = "启用")
    @PatchMapping(value = "/{id}/v")
    public HttpResult<Void> active(@PathVariable("id") Long id) {
        logger.info("[Rosefinch][Config] active by id = {}", id);
        rosefinchConfigService.active(id);
        return HttpResult.ok();
    }

    @ApiOperation(value = "禁用")
    @PatchMapping(value = "/{id}/x")
    public HttpResult<Void> inactive(@PathVariable("id") Long id) {
        logger.info("[Rosefinch][Config] inactive by id = {}", id);
        rosefinchConfigService.inactive(id);
        return HttpResult.ok();
    }

    @ApiOperation(value = "批量物理删除")
    @DeleteMapping(value = "/delete")
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[Rosefinch][Config] batch physical delete by ids = {}", ids);
        rosefinchConfigService.delete(ids);
        return HttpResult.ok();
    }
}
