/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.data.controller;

import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigPagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigPagingVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u914d\u7f6e\u8868"})
@RestController
@RequestMapping(value={"/rosefinch/config"})
public class RosefinchConfigController {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchConfigController.class);
    private final RosefinchConfigService rosefinchConfigService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<RosefinchConfigPagingVO>> list(@RequestBody RosefinchConfigPagingParamVO query) {
        logger.info("[Rosefinch][Config] query paging param = {}", (Object)query);
        return HttpResult.ok(this.rosefinchConfigService.rosefinchConfigPageBy(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<RosefinchConfigDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[Rosefinch][Config] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.rosefinchConfigService.rosefinchConfigById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody RosefinchConfigSaveParamVO saveParam) {
        logger.info("[Rosefinch][Config] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.rosefinchConfigService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Void> active(@PathVariable(value="id") Long id) {
        logger.info("[Rosefinch][Config] active by id = {}", (Object)id);
        this.rosefinchConfigService.active(id);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public HttpResult<Void> inactive(@PathVariable(value="id") Long id) {
        logger.info("[Rosefinch][Config] inactive by id = {}", (Object)id);
        this.rosefinchConfigService.inactive(id);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[Rosefinch][Config] batch physical delete by ids = {}", ids);
        this.rosefinchConfigService.delete(ids);
        return HttpResult.ok();
    }

    public RosefinchConfigController(RosefinchConfigService rosefinchConfigService) {
        this.rosefinchConfigService = rosefinchConfigService;
    }
}

