/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.data.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.rosefinch.client.queue.producer.ProducerProxy;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskInfo;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.data.convert.RosefinchConfigConvert;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchConfigRepo;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchConfigRepoProc;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigPagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigQueryParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigPagingVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.spi.RosefinchStatusListener;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RosefinchConfigServiceImpl
implements RosefinchConfigService {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchConfigServiceImpl.class);
    private final RosefinchConfigRepo rosefinchConfigRepo;
    private final RosefinchConfigRepoProc rosefinchConfigRepoProc;
    @Autowired(required=false)
    private ProducerProxy producerProxy;
    private final List<RosefinchStatusListener> rosefinchStatusListeners;

    @Override
    public PagingVO<RosefinchConfigPagingVO> rosefinchConfigPageBy(RosefinchConfigPagingParamVO query) {
        long count = this.rosefinchConfigRepoProc.rosefinchConfigCountBy(query);
        if (count > 0L) {
            List<RosefinchConfigDO> list = this.rosefinchConfigRepoProc.rosefinchConfigPageBy(query);
            return new PagingVO(count, RosefinchConfigConvert.INSTANCE.doToPageVO(list));
        }
        return new PagingVO();
    }

    @Override
    public List<RosefinchConfigDetailVO> rosefinchConfigByParam(RosefinchConfigQueryParamVO query) {
        return this.rosefinchConfigRepoProc.rosefinchConfigByParam(query);
    }

    @Override
    public RosefinchConfigDetailVO rosefinchConfigById(Long id) {
        Optional rosefinchConfigDO = this.rosefinchConfigRepo.findById(id);
        if (rosefinchConfigDO.isEmpty()) {
            throw new RuntimeException("Not Found Data");
        }
        return RosefinchConfigConvert.INSTANCE.doToVO((RosefinchConfigDO)rosefinchConfigDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(RosefinchConfigSaveParamVO saveParam) {
        boolean exists = this.rosefinchConfigRepoProc.existsByCode(saveParam.getId(), saveParam.getTaskCode());
        Assert.isFalse((boolean)exists, (String)("\u4efb\u52a1\u7f16\u7801(" + saveParam.getTaskCode() + ")\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        if (saveParam.isNew()) {
            RosefinchConfigDO rosefinchConfigDO = RosefinchConfigConvert.INSTANCE.saveParamToDO(saveParam);
            this.rosefinchConfigRepo.save(rosefinchConfigDO);
            this.updateStatus(RosefinchConfigConvert.INSTANCE.doToVO(rosefinchConfigDO), ActiveStatus.ACTIVE.getCode());
            return rosefinchConfigDO.getId();
        }
        Optional rosefinchConfigDO = this.rosefinchConfigRepo.findById(saveParam.getId());
        if (rosefinchConfigDO.isEmpty()) {
            throw new RuntimeException("Not Found Data");
        }
        RosefinchConfigDO rosefinchConfig = (RosefinchConfigDO)rosefinchConfigDO.get();
        RosefinchConfigConvert.INSTANCE.saveParamMergeToDO(saveParam, rosefinchConfig);
        this.rosefinchConfigRepo.save(rosefinchConfig);
        this.updateStatus(RosefinchConfigConvert.INSTANCE.doToVO(rosefinchConfig), ActiveStatus.INACTIVE.getCode());
        return rosefinchConfig.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void active(Long id) {
        RosefinchConfigDetailVO rosefinchCfg = this.rosefinchConfigById(id);
        this.rosefinchConfigRepoProc.updateStatus(id, ActiveStatus.ACTIVE.getCode());
        this.updateStatus(rosefinchCfg, ActiveStatus.ACTIVE.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void inactive(Long id) {
        RosefinchConfigDetailVO rosefinchCfg = this.rosefinchConfigById(id);
        this.rosefinchConfigRepoProc.updateStatus(id, ActiveStatus.INACTIVE.getCode());
        this.updateStatus(rosefinchCfg, ActiveStatus.INACTIVE.getCode());
    }

    private void updateStatus(RosefinchConfigDetailVO rosefinchCfg, Integer status) {
        if (CollUtil.isNotEmpty(this.rosefinchStatusListeners)) {
            this.rosefinchStatusListeners.stream().filter(listener -> listener.supports(rosefinchCfg)).forEach(listener -> {
                if (ObjectUtil.equals((Object)ActiveStatus.ACTIVE.getCode(), (Object)status)) {
                    listener.active(rosefinchCfg);
                }
                if (Objects.equals(ActiveStatus.INACTIVE.getCode(), status)) {
                    listener.inactive(rosefinchCfg);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<Long> ids) {
        this.rosefinchConfigRepo.deleteAllById(ids);
    }

    @Override
    public void execute(String taskCode, Object payload) {
        Optional<RosefinchConfigDO> rosefinchConfigDO = this.rosefinchConfigRepo.findByTaskCode(taskCode);
        if (rosefinchConfigDO.isEmpty()) {
            throw new RuntimeException("Not Found Data");
        }
        TaskInfo taskInfo = RosefinchConfigConvert.INSTANCE.doToRequest(rosefinchConfigDO.get());
        this.execute(TaskMessage.withPayload((TaskInfo)taskInfo, (Object)payload));
    }

    @Override
    public void execute(TaskMessage payload) {
        if (this.producerProxy == null) {
            throw new RuntimeException("Rosefinch\u6a21\u5757\u672a\u5f00\u542f");
        }
        try {
            this.producerProxy.send(payload);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("[ROSEFINCH] \u4efb\u52a1\u6267\u884c\u5f02\u5e38: ", (Throwable)e);
            throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
    }

    @Override
    public Runnable runAuto(TaskMessage payload) {
        String tenantCode = TenantSpiUtil.currentTenantCode();
        if (this.producerProxy == null) {
            throw new RuntimeException("Rosefinch\u6a21\u5757\u672a\u5f00\u542f");
        }
        try {
            Runnable executor = () -> {
                try {
                    this.producerProxy.send(payload, "\u81ea\u52a8\u6267\u884c");
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            };
            if (RosefinchUtil.noTenant()) {
                return executor;
            }
            return () -> TenantSpiUtil.byTenantDirectly((Runnable)executor, (String)tenantCode);
        }
        catch (Exception e) {
            logger.error("[ROSEFINCH] \u4efb\u52a1\u6267\u884c\u5f02\u5e38: ", (Throwable)e);
            throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
    }

    @Override
    public boolean stopImmediately(RosefinchInstanceDetailVO instance) {
        if (ObjectUtil.isNull((Object)this.producerProxy)) {
            throw new RuntimeException("Rosefinch\u6a21\u5757\u672a\u5f00\u542f");
        }
        return this.producerProxy.stop(instance.getTaskCode(), instance.getId().longValue());
    }

    public RosefinchConfigServiceImpl(RosefinchConfigRepo rosefinchConfigRepo, RosefinchConfigRepoProc rosefinchConfigRepoProc, List<RosefinchStatusListener> rosefinchStatusListeners) {
        this.rosefinchConfigRepo = rosefinchConfigRepo;
        this.rosefinchConfigRepoProc = rosefinchConfigRepoProc;
        this.rosefinchStatusListeners = rosefinchStatusListeners;
    }
}

