/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.proxy;

import cn.hutool.core.net.NetUtil;
import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import com.elitesland.cbpl.rosefinch.client.queue.producer.ProducerProxy;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.common.constant.InstanceStatus;
import com.elitesland.cbpl.rosefinch.data.convert.RosefinchConfigConvert;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.proxy.domain.RosefinchMessage;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.util.RosefinchTraceUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.redis.util.RedisUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.lzhpo.tracer.util.TracerUtils;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class ProducerProxyService
implements ProducerProxy {
    private static final Logger logger = LoggerFactory.getLogger(ProducerProxyService.class);
    private final RosefinchInstanceService instanceService;
    private final QueueHandlerService handlerService;
    private final RedisUtil redisUtil;

    public Long send(TaskMessage payload, String runType) {
        RosefinchTraceUtil.initTraceId();
        RosefinchInstanceSaveParamVO instance = this.instanceLog(payload, runType);
        payload.setInstanceDTO(RosefinchConfigConvert.INSTANCE.saveParamToDTO(instance));
        this.handlerService.publish(payload);
        RosefinchTraceUtil.clearTraceId();
        return instance.getId();
    }

    public boolean stop(String taskCode, long instanceId) {
        this.redisUtil.publishMessage("instance_stop_channel", (Object)this.of(taskCode, instanceId));
        return true;
    }

    private RosefinchInstanceSaveParamVO instanceLog(TaskMessage payload, String runType) {
        RosefinchInstanceSaveParamVO saveParam = new RosefinchInstanceSaveParamVO();
        saveParam.setMasId(payload.getTaskId());
        saveParam.setTaskName(payload.getTaskName());
        saveParam.setTaskCode(payload.getTaskCode());
        saveParam.setRunType(runType);
        saveParam.setInstanceStatus(InstanceStatus.READY.getCode());
        saveParam.setStartTime(LocalDateTime.now());
        saveParam.setGlobalTraceId(TracerUtils.getTraceId());
        saveParam.setTraceId(RosefinchTraceUtil.getTraceId());
        saveParam.setServerIp(NetUtil.getLocalhostStr());
        if (RosefinchType.BATCH.getCode().compareTo(payload.getTaskType()) == 0) {
            saveParam.setTotalCount(payload.size());
            saveParam.setSuccessCount(0);
            saveParam.setFailCount(0);
        } else {
            saveParam.setMethodArgs(BeanUtils.toJsonOrEmpty((Object)payload.getPayload()));
        }
        Long instanceId = this.instanceService.save(saveParam);
        saveParam.setId(instanceId);
        return saveParam;
    }

    private RosefinchMessage of(String taskCode, long instanceId) {
        RosefinchMessage message = new RosefinchMessage();
        message.setTaskCode(taskCode);
        message.setInstanceId(instanceId);
        message.setTenantCode(TenantSpiUtil.currentTenantCode());
        return message;
    }

    public ProducerProxyService(RosefinchInstanceService instanceService, QueueHandlerService handlerService, RedisUtil redisUtil) {
        this.instanceService = instanceService;
        this.handlerService = handlerService;
        this.redisUtil = redisUtil;
    }
}

