package com.elitesland.cbpl.rosefinch.data.convert;

import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskInfo;
import com.elitesland.cbpl.rosefinch.client.register.dto.RosefinchSaveParamDTO;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigPagingVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Mapper(config = BaseMapperConfig.class)
public interface RosefinchConfigConvert {

    RosefinchConfigConvert INSTANCE = Mappers.getMapper(RosefinchConfigConvert.class);

    /**
     * DO => PageVO
     */
    List<RosefinchConfigPagingVO> doToPageVO(List<RosefinchConfigDO> rosefinchConfigDO);

    /**
     * DO => RespVO
     */
    RosefinchConfigDetailVO doToVO(RosefinchConfigDO rosefinchConfigDO);

    /**
     * SaveParam => DO
     */
    RosefinchConfigDO saveParamToDO(RosefinchConfigSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(RosefinchConfigSaveParamVO saveParam, @MappingTarget RosefinchConfigDO rosefinchConfigDO);

    /**
     * DO => RequestParam
     */
    @Mapping(target = "taskId", source = "id")
    TaskInfo doToRequest(RosefinchConfigDO rosefinchConfigDO);

    /**
     * DetailVO => RequestParam
     */
    @Mapping(target = "taskId", source = "id")
    TaskInfo voToRequest(RosefinchConfigDetailVO configVO);

    /**
     * SaveParamDTO => SaveParamVO
     */
    RosefinchConfigSaveParamVO toSaveParam(RosefinchSaveParamDTO saveParamDTO);

    /**
     * SaveParam => DTO
     */
    InstanceDTO saveParamToDTO(RosefinchInstanceSaveParamVO instance);
}
