/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.data.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.rosefinch.data.entity.QRosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.entity.QRosefinchInstanceDO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceDeleteParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstancePagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstancePagingVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceRespVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class RosefinchInstanceRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QRosefinchConfigDO rosefinchConfigDO = QRosefinchConfigDO.rosefinchConfigDO;
    private static final QRosefinchInstanceDO rosefinchInstanceDO = QRosefinchInstanceDO.rosefinchInstanceDO;
    private final QBean<RosefinchInstancePagingVO> rosefinchInstancePagingVO;
    private final QBean<RosefinchInstanceRespVO> rosefinchInstanceVO;

    private Predicate pagingWhere(RosefinchInstancePagingParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getAppCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getAppCodeName());
            predicates.add(RosefinchInstanceRepoProc.rosefinchConfigDO.appCode.eq((Object)query.getAppCodeName()).or((Predicate)RosefinchInstanceRepoProc.rosefinchConfigDO.appName.like(likeStr)));
        }
        if (ObjectUtil.isNotNull((Object)query.getTaskCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskCodeName());
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.eq((Object)query.getTaskCodeName()).or((Predicate)RosefinchInstanceRepoProc.rosefinchInstanceDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getInstanceStatus())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus.eq((Object)query.getInstanceStatus()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStartTime())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime.eq((Object)query.getStartTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getEndTime())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime.eq((Object)query.getEndTime()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getErrorMessage())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage.eq((Object)query.getErrorMessage()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getGlobalTraceId())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.globalTraceId.eq((Object)query.getGlobalTraceId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTraceId())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId.eq((Object)query.getTraceId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskTag())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchConfigDO.taskTag.eq((Object)query.getTaskTag()));
        } else {
            predicates.add(RosefinchInstanceRepoProc.rosefinchConfigDO.taskTag.isNull());
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long rosefinchInstanceCountBy(RosefinchInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(RosefinchInstanceRepoProc.rosefinchInstanceDO.id).from((EntityPath)rosefinchInstanceDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)RosefinchInstanceRepoProc.rosefinchConfigDO.id.eq(RosefinchInstanceRepoProc.rosefinchInstanceDO.masId));
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<RosefinchInstancePagingVO> rosefinchInstancePageBy(RosefinchInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.rosefinchInstancePagingVO).from((EntityPath)rosefinchInstanceDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)RosefinchInstanceRepoProc.rosefinchConfigDO.id.eq(RosefinchInstanceRepoProc.rosefinchInstanceDO.masId));
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, rosefinchInstanceDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public RosefinchInstanceRespVO findById(Long instanceId) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag.eq((Object)0));
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.id.eq((Object)instanceId));
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.rosefinchInstanceVO).from((EntityPath)rosefinchInstanceDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)RosefinchInstanceRepoProc.rosefinchConfigDO.id.eq(RosefinchInstanceRepoProc.rosefinchInstanceDO.masId));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return (RosefinchInstanceRespVO)jpaQuery.fetchOne();
    }

    public List<String> delete(RosefinchInstanceDeleteParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.eq((Object)paramVO.getTaskCode()));
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus.in(paramVO.getInstanceStatus()));
        if (ObjectUtil.isNotNull((Object)paramVO.getBeforeTime())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime.lt((Comparable)paramVO.getBeforeTime()));
        }
        Predicate predicate = ExpressionUtils.allOf(predicates);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(RosefinchInstanceDetailVO.class, (Expression[])new Expression[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId})).from((EntityPath)rosefinchInstanceDO)).where(predicate);
        List<String> traceIds = jpaQuery.fetch().stream().map(RosefinchInstanceDetailVO::getTraceId).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(traceIds)) {
            JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)rosefinchInstanceDO).where(new Predicate[]{predicate});
            delete.execute();
        }
        return traceIds;
    }

    public List<String> deleteByIds(List<Long> instanceIds) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.id.in(instanceIds));
        Predicate predicate = ExpressionUtils.allOf(predicates);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(RosefinchInstanceDetailVO.class, (Expression[])new Expression[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId})).from((EntityPath)rosefinchInstanceDO)).where(predicate);
        List<String> traceIds = jpaQuery.fetch().stream().map(RosefinchInstanceDetailVO::getTraceId).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(traceIds)) {
            JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)rosefinchInstanceDO).where(new Predicate[]{predicate});
            delete.execute();
        }
        return traceIds;
    }

    public long update(RosefinchInstanceSaveParamVO saveParam) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)rosefinchInstanceDO).set(RosefinchInstanceRepoProc.rosefinchInstanceDO.executeTime, (Object)saveParam.getExecuteTime()).where(new Predicate[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.id.eq((Object)saveParam.getId())});
        if (StrUtil.isNotBlank((CharSequence)saveParam.getTraceId())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId, (Object)saveParam.getTraceId());
        }
        if (ObjectUtil.isNotNull((Object)saveParam.getEndTime())) {
            update.set(RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime, (Object)saveParam.getEndTime());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getErrorMessage())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage, (Object)saveParam.getErrorMessage());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getInstanceStatus())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus, (Object)saveParam.getInstanceStatus());
        }
        if (ObjectUtil.isNotNull((Object)saveParam.getTotalCount())) {
            update.set(RosefinchInstanceRepoProc.rosefinchInstanceDO.totalCount, (Object)saveParam.getTotalCount());
        }
        if (ObjectUtil.isNotNull((Object)saveParam.getSuccessCount())) {
            update.set(RosefinchInstanceRepoProc.rosefinchInstanceDO.successCount, (Object)saveParam.getSuccessCount());
        }
        if (ObjectUtil.isNotNull((Object)saveParam.getFailCount())) {
            update.set(RosefinchInstanceRepoProc.rosefinchInstanceDO.failCount, (Object)saveParam.getFailCount());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getFilePath())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.filePath, (Object)saveParam.getFilePath());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getRemark())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.remark, (Object)saveParam.getRemark());
        }
        return update.execute();
    }

    public RosefinchInstanceRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.rosefinchInstancePagingVO = Projections.bean(RosefinchInstancePagingVO.class, (Expression[])new Expression[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.id, RosefinchInstanceRepoProc.rosefinchInstanceDO.masId, RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskCode).as("taskCode"), RosefinchInstanceRepoProc.rosefinchInstanceDO.taskName.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskName).as("taskName"), RosefinchInstanceRepoProc.rosefinchInstanceDO.runType, RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus, RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.executeTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage, RosefinchInstanceRepoProc.rosefinchInstanceDO.globalTraceId, RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId, RosefinchInstanceRepoProc.rosefinchInstanceDO.methodArgs, RosefinchInstanceRepoProc.rosefinchInstanceDO.totalCount, RosefinchInstanceRepoProc.rosefinchInstanceDO.successCount, RosefinchInstanceRepoProc.rosefinchInstanceDO.failCount, RosefinchInstanceRepoProc.rosefinchInstanceDO.filePath, RosefinchInstanceRepoProc.rosefinchInstanceDO.serverIp, RosefinchInstanceRepoProc.rosefinchInstanceDO.tenantId, RosefinchInstanceRepoProc.rosefinchInstanceDO.remark, RosefinchInstanceRepoProc.rosefinchInstanceDO.createUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.creator, RosefinchInstanceRepoProc.rosefinchInstanceDO.createTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.updater, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag, RosefinchInstanceRepoProc.rosefinchInstanceDO.customFields});
        this.rosefinchInstanceVO = Projections.bean(RosefinchInstanceRespVO.class, (Expression[])new Expression[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.id, RosefinchInstanceRepoProc.rosefinchInstanceDO.masId, RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskCode).as("taskCode"), RosefinchInstanceRepoProc.rosefinchInstanceDO.taskName.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskName).as("taskName"), RosefinchInstanceRepoProc.rosefinchInstanceDO.runType, RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus, RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.executeTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage, RosefinchInstanceRepoProc.rosefinchInstanceDO.globalTraceId, RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId, RosefinchInstanceRepoProc.rosefinchInstanceDO.methodArgs, RosefinchInstanceRepoProc.rosefinchInstanceDO.totalCount, RosefinchInstanceRepoProc.rosefinchInstanceDO.successCount, RosefinchInstanceRepoProc.rosefinchInstanceDO.failCount, RosefinchInstanceRepoProc.rosefinchInstanceDO.filePath, RosefinchInstanceRepoProc.rosefinchInstanceDO.tenantId, RosefinchInstanceRepoProc.rosefinchInstanceDO.remark, RosefinchInstanceRepoProc.rosefinchInstanceDO.createUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.creator, RosefinchInstanceRepoProc.rosefinchInstanceDO.createTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.updater, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag, RosefinchInstanceRepoProc.rosefinchInstanceDO.customFields});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

