/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.data.service.impl;

import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.util.LogConfigUtil;
import com.elitesland.cbpl.rosefinch.data.convert.RosefinchInstanceConvert;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchInstanceDO;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchInstanceRepo;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchInstanceRepoProc;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceDeleteParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstancePagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstancePagingVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceRespVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class RosefinchInstanceServiceImpl
implements RosefinchInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchInstanceServiceImpl.class);
    private final PipelineService pipelineService;
    private final RosefinchInstanceRepo rosefinchInstanceRepo;
    private final RosefinchInstanceRepoProc rosefinchInstanceRepoProc;

    @Override
    public PagingVO<RosefinchInstancePagingVO> rosefinchInstancePageBy(RosefinchInstancePagingParamVO query) {
        long count = this.rosefinchInstanceRepoProc.rosefinchInstanceCountBy(query);
        if (count > 0L) {
            List<RosefinchInstancePagingVO> list = this.rosefinchInstanceRepoProc.rosefinchInstancePageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public RosefinchInstanceDetailVO rosefinchInstanceById(Long id) {
        RosefinchInstanceRespVO instanceVO = this.rosefinchInstanceRepoProc.findById(id);
        return RosefinchInstanceConvert.INSTANCE.respToVO(instanceVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(RosefinchInstanceSaveParamVO saveParam) {
        Assert.notNull((Object)saveParam.getId(), (String)"Missing Primary Key");
        this.rosefinchInstanceRepoProc.update(saveParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Long save(RosefinchInstanceSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            RosefinchInstanceDO rosefinchInstanceDO = RosefinchInstanceConvert.INSTANCE.saveParamToDO(saveParam);
            this.rosefinchInstanceRepo.save(rosefinchInstanceDO);
            return rosefinchInstanceDO.getId();
        }
        Optional rosefinchInstanceDO = this.rosefinchInstanceRepo.findById(saveParam.getId());
        if (rosefinchInstanceDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        RosefinchInstanceDO rosefinchInstance = (RosefinchInstanceDO)rosefinchInstanceDO.get();
        RosefinchInstanceConvert.INSTANCE.saveParamMergeToDO(saveParam, rosefinchInstance);
        this.rosefinchInstanceRepo.save(rosefinchInstance);
        return rosefinchInstance.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long deleteInstance(RosefinchInstanceDeleteParamVO paramVO, String source) {
        if (!paramVO.isEmpty()) {
            logger.debug("[ROSEFINCH] {} delete instance: {}", (Object)source, (Object)BeanUtils.toJsonStr((Object)paramVO));
            List<String> traceIds = this.rosefinchInstanceRepoProc.delete(paramVO);
            this.trackDocDelete(traceIds);
            return traceIds.size();
        }
        return 0L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> delete(List<Long> instanceIds) {
        List<String> traceIds = this.rosefinchInstanceRepoProc.deleteByIds(instanceIds);
        this.trackDocDelete(traceIds);
        return traceIds;
    }

    private void trackDocDelete(List<String> traceIds) {
        TrackDocDeleteParamVO trackDeleteParam = new TrackDocDeleteParamVO();
        trackDeleteParam.setTraceIds(traceIds);
        LogConfigUtil.supply(() -> this.pipelineService.trackDocDelete(trackDeleteParam), (LoggingProperty)LoggingProperties.LOG_SYSLOG_CFG);
    }

    public RosefinchInstanceServiceImpl(PipelineService pipelineService, RosefinchInstanceRepo rosefinchInstanceRepo, RosefinchInstanceRepoProc rosefinchInstanceRepoProc) {
        this.pipelineService = pipelineService;
        this.rosefinchInstanceRepo = rosefinchInstanceRepo;
        this.rosefinchInstanceRepoProc = rosefinchInstanceRepoProc;
    }
}

