package com.elitesland.cbpl.rosefinch.queue.producer;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.client.queue.consumer.ConsumerWrapper;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * @author eric.hao
 * @since 2024/06/24
 */
@Slf4j
@RequiredArgsConstructor
public class SyncQueueProducer implements QueueHandlerService {

    /**
     * 同步执行
     */
    @Override
    public void publish(TaskMessage payload) {
        try {
            LogUtil.info(payload.getTaskCode(), null, "[ROSEFINCH][DEFAULT] 任务发布: ", null, null);
            ConsumerWrapper proxy = SpringUtil.getBean(ConsumerWrapper.class);
            payload.setParentMdc(MDC.getCopyOfContextMap());
            proxy.consumer(payload);
        } catch (NoSuchBeanDefinitionException e) {
            LogUtil.error(payload.getTaskCode(), null,
                    "[ROSEFINCH][DEFAULT] 任务(" + payload.getTaskCode() + ") 处理异常：",
                    null, e, null
            );
        }
    }

    @Override
    public boolean stopImmediately(String instanceKey) {
        return false;
    }
}
