package com.elitesland.cbpl.rosefinch.data.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.PageQueryParam;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务实例表
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Data
@ApiModel("任务实例表")
public class RosefinchInstancePagingParamVO extends PageQueryParam {

	private static final long serialVersionUID = -4250858389215127914L;

	@ApiModelProperty(value = "应用编码/名称")
	private String appCodeName;

	@ApiModelProperty(value = "任务编码/名称")
	private String taskCodeName;

	@ApiModelProperty(value = "分组标签")
	private String taskTag;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "全局链路ID")
	private String globalTraceId;

	@ApiModelProperty(value = "日志链路ID")
	private String traceId;

	@ApiModelProperty(value = "开始时间")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "结束时间")
	private LocalDateTime endTime;
}
