package com.elitesland.cbpl.rosefinch.data.vo.resp;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.common.constant.YesOrNo;
import com.elitesland.cbpl.logging.common.constant.DeletionStrategy;
import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务配置表
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Data
@ApiModel("任务配置表")
public class RosefinchConfigPagingVO implements Serializable {

    private static final long serialVersionUID = 156340882727614074L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "分组标签")
    private String taskTag;

    @ApiModelProperty(value = "定时任务名称")
    private String taskName;

    @ApiModelProperty(value = "定时任务编码")
    private String taskCode;

    /**
     * {@link RosefinchType}
     */
    @ApiModelProperty(value = "任务类型")
    private Integer taskType;

    @ApiModelProperty(value = "类名")
    private String className;

    @ApiModelProperty(value = "方法名")
    private String method;

    @ApiModelProperty(value = "方法固定参数(JSON字符串)")
    private String methodArgs;

    @ApiModelProperty(value = "状态：0禁用；1启用；")
    private Integer status;

    @ApiModelProperty(value = "状态中文")
    private String statusName;

    @JsonProperty
    public String getStatusName() {
        return ActiveStatus.fromCode(status);
    }

    @ApiModelProperty(value = "定时任务是否开启")
    private Integer scheduleFlag;

    @ApiModelProperty(value = "定时任务是否开启中文")
    private String scheduleFlagName;

    @JsonProperty
    public String getScheduleFlagName() {
        return YesOrNo.fromCode(scheduleFlag);
    }

    @ApiModelProperty(value = "告警推送是否开启")
    private Integer warnFlag;

    @ApiModelProperty(value = "告警推送是否开启中文")
    private String warnFlagName;

    @JsonProperty
    public String getWarnFlagName() {
        return YesOrNo.fromCode(warnFlag);
    }

    @ApiModelProperty(value = "实例删除策略")
    private String deletionStrategy;

    @JsonProperty
    public String getDeletionStrategy() {
        return StrUtil.blankToDefault(deletionStrategy, DeletionStrategy.NO_DELETION.getDays());
    }

    @ApiModelProperty(value = "实例删除策略中文")
    private String deletionStrategyName;

    @JsonProperty
    public String getDeletionStrategyName() {
        return DeletionStrategy.fromDays(getDeletionStrategy());
    }

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "记录创建者")
    private String creator;

    @ApiModelProperty(value = "记录创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "自定义字段(JSON字符串)")
    private String customFields;
}
