package com.elitesland.cbpl.rosefinch.data.convert;

import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchInstanceDO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceRespVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Mapper(config = BaseMapperConfig.class)
public interface RosefinchInstanceConvert {

	RosefinchInstanceConvert INSTANCE = Mappers.getMapper(RosefinchInstanceConvert.class);

    /**
     * DO => RespVO
     */
    RosefinchInstanceDetailVO doToVO(RosefinchInstanceDO rosefinchInstanceDO);

    /**
     * SaveParam => DO
     */
    RosefinchInstanceDO saveParamToDO(RosefinchInstanceSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(RosefinchInstanceSaveParamVO saveParam, @MappingTarget RosefinchInstanceDO rosefinchInstanceDO);

    /**
     * RespVO => DetailVO
     */
    RosefinchInstanceDetailVO respToVO(RosefinchInstanceRespVO instanceVO);

    /**
     * RespVO => DTO
     */
    InstanceDTO voToDTO(RosefinchInstanceRespVO instanceVO);
}
