package com.elitesland.cbpl.rosefinch.data.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务实例表
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_rosefinch_instance")
@org.hibernate.annotations.Table(appliesTo = "sys_rosefinch_instance", comment = "任务实例表")
@ApiModel("任务实例表")
public class RosefinchInstanceDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 4605073231590347419L;

    /**
     * 任务ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "任务ID")
    @Column(name = "mas_id", nullable = true, length = 20)
    private Long masId;

    /**
     * 定时任务名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务名称")
    @Column(name = "task_name", nullable = true, length = 64)
    private String taskName;

    /**
     * 定时任务编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务编码")
    @Column(name = "task_code", nullable = true, length = 64)
    private String taskCode;

    /**
     * 执行方式：AUTO自动执行；INVOKE手动执行；
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "执行方式：AUTO自动执行；INVOKE手动执行；")
    @Column(name = "run_type", nullable = true, length = 8)
    private String runType;

    /**
     * 日志行状态
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "日志行状态")
    @Column(name = "instance_status", nullable = true, length = 16)
    private String instanceStatus;

    /**
     * 开始时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "开始时间")
    @Column(name = "start_time", nullable = true)
    private LocalDateTime startTime;

    /**
     * 执行时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "执行时间")
    @Column(name = "execute_time", nullable = true)
    private LocalDateTime executeTime;

    /**
     * 结束时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "结束时间")
    @Column(name = "end_time", nullable = true)
    private LocalDateTime endTime;

    /**
     * 错误日志
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "错误日志")
    @Column(name = "error_message", nullable = true, length = 255)
    private String errorMessage;

    /**
     * 全局链路ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "全局链路ID")
    @Column(name = "global_trace_id", nullable = true, length = 64)
    private String globalTraceId;

    /**
     * 日志链路ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "日志链路ID")
    @Column(name = "trace_id", nullable = true, length = 64)
    private String traceId;

    /**
     * 调用传值(JSON字符串)
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "调用传值(JSON字符串)")
    @Column(name = "method_args", nullable = true)
    private String methodArgs;

    /**
     * 总行数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "总行数")
    @Column(name = "total_count", nullable = true, length = 11)
    private Integer totalCount;

    /**
     * 成功行数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "成功行数")
    @Column(name = "success_count", nullable = true, length = 11)
    private Integer successCount;

    /**
     * 失败行数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "失败行数")
    @Column(name = "fail_count", nullable = true, length = 11)
    private Integer failCount;

    /**
     * 文件下载路径
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "文件下载路径")
    @Column(name = "file_path", nullable = true, length = 255)
    private String filePath;

    /**
     * 服务器IP
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "服务器IP")
    @Column(name = "server_ip", nullable = true, length = 255)
    private String serverIp;
}
