/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.convert.ScheduleConfigConvert;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.entity.ScheduleConfigDO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.repo.ScheduleConfigRepo;
import com.elitesland.cbpl.scheduling.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.repo.ScheduleInstanceRepoProc;
import com.elitesland.cbpl.scheduling.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.spi.ScheduleInstanceSpi;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceDeleteParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigRespVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.cron.CronPatternUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScheduleConfigServiceImpl
implements ScheduleConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfigServiceImpl.class);
    private final ScheduleConfigRepo scheduleConfigRepo;
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    private final ScheduleInstanceRepoProc scheduleInstanceRepoProc;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;
    @Autowired(required=false)
    private ScheduleInstanceSpi scheduleInstanceService;

    @Override
    public PagingVO<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query) {
        long count = this.scheduleConfigRepoProc.scheduleConfigCountBy(query);
        if (count > 0L) {
            List<ScheduleConfigPagingVO> list = this.scheduleConfigRepoProc.scheduleConfigPageBy(query);
            if (ObjectUtil.isNotNull((Object)this.scheduleInstanceService)) {
                this.scheduleInstanceService.instanceWrap(list);
            }
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public List<ScheduledTask> scheduleConfigByParam(ScheduleConfigQueryParamVO query) {
        List<ScheduleConfigRespVO> tasks = this.scheduleConfigRepoProc.scheduleConfigByParam(query);
        return tasks.stream().map(row -> ScheduledTask.builder().taskId(row.getId()).taskCode(row.getTaskCode()).taskName(row.getTaskName()).build().setTrigger(row.getClassName(), row.getMethod(), row.getCron())).collect(Collectors.toList());
    }

    @Override
    public ScheduleConfigDetailVO scheduleConfigById(Long id) {
        ScheduleConfigRespVO scheduleConfigVO = this.scheduleConfigRepoProc.findById(id);
        if (ObjectUtil.isNull((Object)scheduleConfigVO)) {
            throw PhoenixException.unchecked((String)"Not Found Data");
        }
        return ScheduleConfigConvert.INSTANCE.respToVO(scheduleConfigVO);
    }

    private ScheduledTask scheduledByTaskId(Long taskId) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigById(taskId);
        return ScheduledTask.builder().taskId(taskId).taskCode(schedule.getTaskCode()).taskName(schedule.getTaskName()).build().setTrigger(schedule.getClassName(), schedule.getMethod(), schedule.getCron());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ScheduleConfigSaveParamVO saveParam) {
        ScheduledTask task = ScheduledTask.builder().taskId(saveParam.getId()).taskCode(saveParam.getTaskCode()).taskName(saveParam.getTaskName()).build().setTrigger(saveParam.getClassName(), saveParam.getMethod(), saveParam.getCron());
        boolean exists = this.scheduleConfigRepoProc.existsByCode(saveParam.getId(), saveParam.getTaskCode());
        Assert.isFalse((boolean)exists, (String)"\u4efb\u52a1\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (saveParam.isNew()) {
            ScheduleConfigDO scheduleConfigDO = ScheduleConfigConvert.INSTANCE.saveParamToDO(saveParam);
            this.scheduleConfigRepo.save(scheduleConfigDO);
            if (scheduleConfigDO.getActiveFlag().equals("1")) {
                this.addTriggerTask(task);
            }
            return scheduleConfigDO.getId();
        }
        Optional scheduleConfigDO = this.scheduleConfigRepo.findById(saveParam.getId());
        if (scheduleConfigDO.isEmpty()) {
            throw PhoenixException.unchecked((String)"Not Found Data");
        }
        ScheduleConfigDO scheduleConfig = (ScheduleConfigDO)scheduleConfigDO.get();
        ScheduleConfigConvert.INSTANCE.saveParamMergeToDO(saveParam, scheduleConfig);
        this.scheduleConfigRepo.save(scheduleConfig);
        if (scheduleConfig.getActiveFlag().equals("1")) {
            this.resetTriggerTask(task);
        }
        return scheduleConfig.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long id, String status) {
        this.scheduleConfigRepoProc.updateStatus(id, status);
        if (status.equals("0")) {
            this.cancelTriggerTask(this.scheduledByTaskId(id));
        } else if (status.equals("1")) {
            this.resetTriggerTask(this.scheduledByTaskId(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(List<Long> ids) {
        ids.stream().map(this::scheduledByTaskId).forEach(this::cancelTriggerTask);
        return this.scheduleConfigRepoProc.updateDeleteFlag(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<Long> ids) {
        ids.stream().map(this::scheduledByTaskId).forEach(this::cancelTriggerTask);
        this.scheduleConfigRepo.deleteAllById(ids);
    }

    @Override
    public Long execute(Long taskId) {
        try {
            return this.runImmediately(this.scheduledByTaskId(taskId));
        }
        catch (RuntimeException e) {
            throw PhoenixException.unchecked((String)("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] execute once error: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            throw PhoenixException.unchecked((String)"\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
    }

    @Override
    public List<String> preview(Long taskId) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigById(taskId);
        return CronPatternUtils.preview((String)schedule.getCron(), (int)20);
    }

    @Override
    public Set<String> taskCodes() {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            return this.schedulingRegistrar.taskCodes();
        }
        return Collections.emptySet();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long deleteInstance(ScheduleInstanceDeleteParamVO paramVO, String source) {
        if (!paramVO.isEmpty()) {
            logger.debug("[PHOENIX-SCHEDULE] {} delete instance: {}", (Object)source, (Object)BeanUtils.toJsonStr((Object)paramVO));
            return this.scheduleInstanceRepoProc.delete(paramVO);
        }
        return 0L;
    }

    @Override
    public List<String> strategyPreview() {
        return CronPatternUtils.preview((String)SchedulingProperties.SCHEDULE_DELETION_CRON, (int)10);
    }

    private void addTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.addTriggerTask(task);
        }
    }

    private void resetTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.resetTriggerTask(task);
        }
    }

    private void cancelTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.cancelTriggerTask(task);
        }
    }

    private Long runImmediately(ScheduledTask task) {
        if (ObjectUtil.isNull((Object)this.schedulingRegistrar)) {
            throw new RuntimeException("Phoenix-Schedule\u6a21\u5757\u672a\u5f00\u542f");
        }
        return this.schedulingRegistrar.runImmediately(task);
    }

    public ScheduleConfigServiceImpl(ScheduleConfigRepo scheduleConfigRepo, ScheduleConfigRepoProc scheduleConfigRepoProc, ScheduleInstanceRepoProc scheduleInstanceRepoProc) {
        this.scheduleConfigRepo = scheduleConfigRepo;
        this.scheduleConfigRepoProc = scheduleConfigRepoProc;
        this.scheduleInstanceRepoProc = scheduleInstanceRepoProc;
    }
}

