/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.task;

import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.domain.InstanceStatus;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.spi.SchedulingRegistrarSpi;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceDeleteParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigRespVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnicomTag(value="__InstanceDeletionTask")
public class InstanceDeletionTask
implements SchedulingRegistrarSpi {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDeletionTask.class);
    private final ScheduleConfigService scheduleConfigService;
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;

    @Override
    public boolean autoRegister() {
        return SchedulingProperties.SCHEDULE_ENABLED;
    }

    @Override
    public ScheduledTask registerTask() {
        return SchedulingUtil.registerTask(this.getClass(), "\u4efb\u52a1\u8c03\u5ea6\u5b9e\u4f8b-\u5b9a\u65f6\u5220\u9664").build().setTrigger(this.getClass().getName(), "deletion", SchedulingProperties.SCHEDULE_DELETION_CRON);
    }

    public void deletion() {
        List<ScheduleConfigRespVO> tasks = this.scheduleConfigRepoProc.scheduleConfigByParam(new ScheduleConfigQueryParamVO());
        for (ScheduleConfigRespVO task : tasks) {
            if (task.noDeletion()) {
                logger.warn("[PHOENIX-SCHEDULE] {} deletion strategy: {}", (Object)task.getTaskCode(), (Object)task.getDeletionStrategyName());
                continue;
            }
            ScheduleInstanceDeleteParamVO deleteParam = new ScheduleInstanceDeleteParamVO();
            deleteParam.setMasId(task.getId());
            deleteParam.setInstanceStatus(List.of(InstanceStatus.COMPLETE.getCode(), InstanceStatus.INTERRUPT.getCode(), InstanceStatus.STOP.getCode()));
            deleteParam.setBeforeTime(SchedulingUtil.minusDays(task.getDeletionStrategy()));
            this.scheduleConfigService.deleteInstance(deleteParam, "AUTO");
        }
    }

    public InstanceDeletionTask(ScheduleConfigService scheduleConfigService, ScheduleConfigRepoProc scheduleConfigRepoProc) {
        this.scheduleConfigService = scheduleConfigService;
        this.scheduleConfigRepoProc = scheduleConfigRepoProc;
    }
}

