package com.elitesland.cbpl.scheduling.config;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ConfigurationProperties(prefix = SCHEDULE_CONFIG_PREFIX)
public class SchedulingProperties implements InitializingBean {

    public static final String SCHEDULE_CONFIG_PREFIX = "cbpl.tool.schedule";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 实例定时删除任务频率，默认每天凌晨`01:20:00`执行
     */
    private String deletionStrategyCron = "0 20 1 * * ?";

    /**
     * 是否查询内置任务：默认不查询
     * <li>双下划线前缀的任务编码，认为是内置任务</li>
     * <li>该参数只影响分页查询的前端接口，其他业务逻辑不受影响</li>
     */
    private boolean isQueryBuildIn;


    public static boolean SCHEDULE_ENABLED;
    public static String SCHEDULE_DELETION_CRON;

    @Override
    public void afterPropertiesSet() throws Exception {
        SCHEDULE_ENABLED = enabled;
        SCHEDULE_DELETION_CRON = deletionStrategyCron;
    }
}
