package com.elitesland.cbpl.scheduling.service;

import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceDeleteParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.tool.db.PagingVO;

import java.util.List;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
public interface ScheduleConfigService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<ScheduledTask> scheduleConfigByParam(ScheduleConfigQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    ScheduleConfigDetailVO scheduleConfigById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ScheduleConfigSaveParamVO saveParam);

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    void updateStatus(Long id, String status);

    /**
     * 批量逻辑删除
     *
     * @param ids 业务单据ID
     * @return 更新成功的数量
     */
    long updateDeleteFlag(List<Long> ids);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    void delete(List<Long> ids);

    /**
     * 立即执行一次
     *
     * @param taskId 任务主键id
     * @return
     */
    Long execute(Long taskId);

    /**
     * CRON表达式预览：列举当前时间后，20个匹配表达式的日期
     *
     * @param taskId 任务主键id
     * @return 实例列表
     */
    List<String> preview(Long taskId);

    /**
     * 所有任务列表
     */
    Set<String> taskCodes();

    /**
     * 删除实例日志
     *
     * @param paramVO 删除参数
     * @param source  调用方式：AUTO定时任务执行；INVOKE手动调用；
     */
    long deleteInstance(ScheduleInstanceDeleteParamVO paramVO, String source);

    /**
     * 日志删除策略-CRON表达式预览
     */
    List<String> strategyPreview();
}
