package com.elitesland.cbpl.scheduling.vo.resp;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.formgenerator.annotation.EnhanceField;
import com.elitesland.cbpl.scheduling.bo.ScheduleConfigBO;
import com.elitesland.cbpl.scheduling.domain.DeletionStrategy;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 定时任务配置表
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ApiModel("定时任务配置表")
public class ScheduleConfigDetailVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "类名")
	private String className;

	@ApiModelProperty(value = "方法名")
	private String method;

	@ApiModelProperty(value = "定时任务表达式")
	private String cron;

	@ApiModelProperty(value = "启用标记")
	private String activeFlag;

	@ApiModelProperty(value = "实例删除策略")
	private String deletionStrategy;

	public String getDeletionStrategy() {
		return StrUtil.blankToDefault(deletionStrategy, DeletionStrategy.NO_DELETION.getDays());
	}

	@ApiModelProperty(value = "实例删除策略中文")
	@JsonProperty
	public String getDeletionStrategyName() {
		return DeletionStrategy.fromDays(getDeletionStrategy());
	}

	@ApiModelProperty(value = "所属租户ID")
	private Long tenantId;

	@ApiModelProperty(value = "所属组织ID")
	private Long belongOrgId;

	@ApiModelProperty(value = "租户组织ID")
	private Long tenantOrgId;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者ID")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者ID")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;

	@ApiModelProperty(value = "锁版本")
	private Integer auditDataVersion;

	@ApiModelProperty(value = "数据归属组织id")
	private Long secBuId;

	@ApiModelProperty(value = "数据归属雇员id")
	private Long secUserId;

	@ApiModelProperty(value = "数据归属公司id")
	private Long secOuId;

	@ApiModelProperty(value = "扩展字段")
	@EnhanceField(relation = ScheduleConfigBO.class)
	private String customFields;
}
