package com.elitesland.cbpl.scheduling.config;

import com.elitesland.cbpl.scheduling.constant.TenantIsolateStrategy;
import lombok.Data;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ConfigurationProperties(prefix = SCHEDULE_CONFIG_PREFIX)
public class SchedulingProperties implements InitializingBean {

    public static final String SCHEDULE_CONFIG_PREFIX = "cbpl.schedule";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 核心线程数，默认4
     */
    private int corePoolSize = 4;

    /**
     * 最大线程数，默认cpu核数
     */
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;

    /**
     * 队列容量，默认1024
     */
    private int queueCapacity = 1024;

    /**
     * <li>拒绝策略：默认`AbortPolicy`</li>
     * <li>see: {@link RejectedTypeEnum}</li>
     */
    private String rejectPolicy = RejectedTypeEnum.ABORT_POLICY.getName();

    /**
     * 实例定时删除任务频率，默认每天凌晨`01:20:00`执行
     */
    private String deletionStrategyCron = "0 20 1 * * ?";

    /**
     * 是否查询内置任务：默认不查询
     * <li>双下划线前缀的任务编码，认为是内置任务</li>
     * <li>该参数只影响分页查询的前端接口，其他业务逻辑不受影响</li>
     */
    private boolean isQueryBuildIn;

    /**
     * 队列解决方案：default、disruptor、rocketmq、kafka
     */
    private String queueSolution = "default";

    /**
     * 租户隔离策略，默认不隔离
     */
    private TenantIsolateStrategy tenantIsolateStrategy = TenantIsolateStrategy.NONE;

    public static boolean SCHEDULE_ENABLED;
    public static String SCHEDULE_DELETION_CRON;
    public static boolean IS_QUERY_BUILD_IN;
    public static TenantIsolateStrategy TENANT_ISOLATE_STRATEGY;

    @Override
    public void afterPropertiesSet() throws Exception {
        SCHEDULE_ENABLED = enabled;
        SCHEDULE_DELETION_CRON = deletionStrategyCron;
        IS_QUERY_BUILD_IN = isQueryBuildIn;
        TENANT_ISOLATE_STRATEGY = tenantIsolateStrategy;
    }
}
