package com.elitesland.cbpl.scheduling.data.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 定时任务实例表
 *
 * @author eric.hao
 * @since 2023/09/12
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_schedule_instance")
@org.hibernate.annotations.Table(appliesTo = "sys_schedule_instance", comment = "定时任务实例表")
@ApiModel("定时任务实例表")
public class ScheduleInstanceDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 2670209428121358520L;

    /**
     * 任务ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "任务ID")
    @Column(name = "mas_id", nullable = true, length = 20)
    private Long masId;

    /**
     * 日志链路ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "日志链路ID")
    @Column(name = "trace_id", nullable = true, length = 64)
    private String traceId;

    /**
     * 定时任务名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务名称")
    @Column(name = "task_name", nullable = true, length = 200)
    private String taskName;

    /**
     * 定时任务编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务编码")
    @Column(name = "task_code", nullable = true, length = 200)
    private String taskCode;

    /**
     * 日志行状态
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "日志行状态")
    @Column(name = "instance_status", nullable = true, length = 2)
    private String instanceStatus;

    /**
     * 错误日志
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "错误日志")
    @Column(name = "error_message", nullable = true, length = 255)
    private String errorMessage;

    /**
     * 开始时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "开始时间")
    @Column(name = "start_time", nullable = true)
    private LocalDateTime startTime;

    /**
     * 执行时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "执行时间")
    @Column(name = "execute_time", nullable = true)
    private LocalDateTime executeTime;

    /**
     * 结束时间
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "结束时间")
    @Column(name = "end_time", nullable = true)
    private LocalDateTime endTime;
}
