package com.elitesland.cbpl.scheduling.registrar;

import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.scheduling.constant.TenantIsolateStrategy;
import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.spi.ScheduleCompleteProvider;
import com.elitesland.cbpl.scheduling.spi.ScheduleInitializeSpi;
import com.elitesland.cbpl.scheduling.spi.SchedulingRegistrarSpi;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.util.ReflectUtils;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.List;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.TENANT_ISOLATE_STRATEGY;

/**
 * @author eric.hao
 * @since 2023/09/07
 */
@Slf4j
@RequiredArgsConstructor
public class ScheduleInitialize implements InitializingBean {

    @Autowired(required = false)
    private ScheduleInitializeSpi scheduleInitializeSpi;
    @Autowired(required = false)
    private ScheduleCompleteProvider scheduleCompleteProvider;
    @Resource
    private ScheduleConfigService scheduleConfigService;
    private final DefaultSchedulingRegistrar schedulingRegistrar;

    public void afterPropertiesSet() {
        new Thread(() -> {
            try {
                // 等待任务调度初始化完成
                while (!schedulingRegistrar.initializeCompleted()) {
                    Thread.sleep(100);
                }
                // 自定义等待任务
                while (scheduleInitializeSpi != null && !scheduleInitializeSpi.initializeCompleted()) {
                    Thread.sleep(100);
                }
                var query = new ScheduleConfigQueryParamVO();
                query.setStatus(ActiveStatus.ACTIVE.getCode());
                Runnable runnable = () -> {
                    List<ScheduledTask> tasks = scheduleConfigService.scheduleConfigByParam(query);
                    tasks.forEach(schedulingRegistrar::addTriggerTask);
                    // 追加自定义扩展任务
                    var register = ReflectUtils.getSubTypesOf(SchedulingRegistrarSpi.class);
                    register.stream().filter(SchedulingRegistrarSpi::autoRegister).forEach(row -> {
                        try {
                            var saveParam = row.registerTask();
                            if (!schedulingRegistrar.hasTask(saveParam.getTaskCode())) {
                                scheduleConfigService.save(saveParam);
                            }
                        } catch (Exception e) {
                            logger.error("[PHOENIX-SCHEDULE] Schedule Registrar SPI failed: {}", ExceptionUtils.formatException(e));
                        }
                    });
                };
                // 租户不隔离
                if (TENANT_ISOLATE_STRATEGY.equals(TenantIsolateStrategy.NONE)) {
                    runnable.run();
                }
                // 按租户隔离
                else {
                    TenantSpiUtil.byTenants(runnable);
                }
            } catch (Exception e) {
                logger.error("[PHOENIX-SCHEDULE] schedule initialize failed: {}", ExceptionUtils.formatException(e));
            }
        }).start();
    }
}
