package com.elitesland.cbpl.scheduling.registrar.domain;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.config.CronTask;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Method;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@Slf4j
@Builder
@ApiModel("任务管理")
public class ScheduledTask {

    @ApiModelProperty("任务ID")
    private Long taskId;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "任务编码")
    private String taskCode;

    @ApiModelProperty(value = "类名")
    private String className;

    @ApiModelProperty(value = "方法名")
    private String methodName;

    @ApiModelProperty(value = "方法参数")
    private String customArgs;

    @ApiModelProperty(value = "定时任务表达式")
    private String cron;

    @ApiModelProperty("触发任务")
    private CronTask triggerTask;

    public ScheduledTask createTriggerTask() {
        Assert.notBlank(className, "类名必填");
        Assert.notBlank(methodName, "方法名必填");
        Assert.notBlank(cron, "表达式必填");
        triggerTask = new CronTask(
                // 执行定时任务
                () -> {
                    Object bean = SpringUtils.getClassBean(className);
                    Object args = SchedulingUtil.parseArgs(customArgs);
                    if (ObjectUtil.isNull(args)) {
                        Method method = ReflectionUtils.findMethod(bean.getClass(), methodName);
                        ReflectionUtils.invokeMethod(method, bean);
                    } else {

                        ReflectUtil.invoke(bean, methodName, args);
                    }
                },
                cron
        );
        return this;
    }
}
