package com.elitesland.cbpl.scheduling.data.service;

import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstancePagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceQueryParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstancePagingVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceRespVO;
import com.elitesland.cbpl.tool.db.PagingVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
public interface ScheduleInstanceService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<ScheduleInstancePagingVO> scheduleInstancePageBy(ScheduleInstancePagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<ScheduleInstanceRespVO> scheduleInstanceByParam(ScheduleInstanceQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    ScheduleInstanceDetailVO scheduleInstanceById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ScheduleInstanceSaveParamVO saveParam);

    /**
     * 更新执行结果
     *
     * @param saveParam 更新参数
     */
    void update(ScheduleInstanceSaveParamVO saveParam);
}
