package com.elitesland.cbpl.scheduling.data.vo.resp;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.scheduling.constant.DeletionStrategy;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 定时任务配置表
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ApiModel("定时任务配置表")
public class ScheduleConfigPagingVO implements Serializable {

	private static final long serialVersionUID = 552105911287335548L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "类名")
	private String className;

	@ApiModelProperty(value = "方法名")
	private String method;

	@ApiModelProperty(value = "方法参数")
	private String customArgs;

	@ApiModelProperty(value = "定时任务表达式")
	private String cron;

	@ApiModelProperty(value = "状态：0禁用；1启用；")
	private Integer status;

	@ApiModelProperty(value = "状态中文")
	private Integer statusName;

	@JsonProperty
	public String getStatusName() {
		return ActiveStatus.fromCode(status);
	}

	@ApiModelProperty(value = "实例删除策略")
	private String deletionStrategy;

	public String getDeletionStrategy() {
		return StrUtil.blankToDefault(deletionStrategy, DeletionStrategy.NO_DELETION.getDays());
	}

	@ApiModelProperty(value = "实例删除策略中文")
	private String deletionStrategyName;

	public String getDeletionStrategyName() {
		return DeletionStrategy.fromDays(getDeletionStrategy());
	}

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "自定义标签")
	private String tags;
}
