package com.elitesland.cbpl.scheduling.queue.producer;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.registrar.execute.ScheduleExecuteHandler;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * @author eric.hao
 * @since 2024/06/24
 */
@Slf4j
@RequiredArgsConstructor
public class DefaultQueueProducer implements ScheduleQueueProducer {

    /**
     * 同步执行
     */
    @Override
    public void send(ScheduleInstanceSaveParamVO instance, Runnable runnable) {
        try {
            ScheduleExecuteHandler handler = SpringUtil.getBean(ScheduleExecuteHandler.class);
            handler.execute(instance, runnable);
        } catch (NoSuchBeanDefinitionException e) {
            LogUtil.error("[CRON][TaskCode][Default] " + instance.getTaskCode() + " consumer error.", e);
        }
    }
}
