package com.elitesland.cbpl.scheduling.registrar.task;

import com.elitesland.cbpl.scheduling.constant.DeletionStrategy;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceDeleteParamVO;
import com.elitesland.cbpl.scheduling.spi.SchedulingDeletionSpi;
import com.elitesland.cbpl.scheduling.spi.SchedulingRegistrarSpi;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_DELETION_CRON;
import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_ENABLED;
import static com.elitesland.cbpl.scheduling.constant.InstanceStatus.*;
import static com.elitesland.cbpl.scheduling.util.SchedulingParamUtil.deletionParamInit;

/**
 * @author eric.hao
 * @since 2024/04/15
 */
@Slf4j
@RequiredArgsConstructor
@UnicomTag("__InstanceDeletionTask")
public class InstanceDeletionTask implements SchedulingRegistrarSpi, SchedulingDeletionSpi {

    private final ScheduleConfigService scheduleConfigService;
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;

    @Override
    public boolean autoRegister() {
        return SCHEDULE_ENABLED;
    }

    @Override
    public ScheduleConfigSaveParamVO registerTask() {
        return deletionParamInit(this.getClass(), "任务调度实例-定时删除", SCHEDULE_DELETION_CRON);
    }

    @Override
    public void deletion() {
        // 所有未删除的任务
        var tasks = scheduleConfigRepoProc.scheduleConfigByParam(new ScheduleConfigQueryParamVO());
        for (var task : tasks) {
            if (DeletionStrategy.NO_DELETION.getDays().equals(task.getDeletionStrategy())) {
                logger.warn("[PHOENIX-SCHEDULE] {} deletion strategy: {}", task.getTaskCode(), task.getDeletionStrategy());
                continue;
            }
            var deleteParam = new ScheduleInstanceDeleteParamVO();
            deleteParam.setTaskCode(task.getTaskCode());
            // 完成、异常中断、手动终止
            deleteParam.setInstanceStatus(List.of(COMPLETE.getCode(), INTERRUPT.getCode(), STOP.getCode()));
            deleteParam.setBeforeTime(SchedulingUtil.minusDays(task.getDeletionStrategy()));
            scheduleConfigService.deleteInstance(deleteParam, "AUTO");
        }
    }
}
