package com.elitesland.cbpl.scheduling.constant;

import lombok.Getter;

/**
 * 租户隔离策略
 *
 * @author eric.hao
 * @since 2024/06/25
 */
@Getter
public enum TenantIsolateStrategy {

    /**
     * 隔离策略
     */
    DATABASE("数据库"), SCHEMA("schema"), FIELD("表字段"), NONE("不隔离");

    /**
     * 描述
     */
    private final String description;

    TenantIsolateStrategy(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.name();
    }
}
