package com.elitesland.cbpl.scheduling.data.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * 定时任务配置表
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_schedule_config")
@org.hibernate.annotations.Table(appliesTo = "sys_schedule_config", comment = "定时任务配置表")
@ApiModel("定时任务配置表")
public class ScheduleConfigDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 5481256175796439392L;

    /**
     * 定时任务名称
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务名称")
    @Column(name = "task_name", nullable = true, length = 200)
    private String taskName;

    /**
     * 定时任务编码
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务编码")
    @Column(name = "task_code", nullable = true, length = 200)
    private String taskCode;

    /**
     * 类名
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "类名")
    @Column(name = "class_name", nullable = true, length = 200)
    private String className;

    /**
     * 方法名
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "方法名")
    @Column(name = "method", nullable = true, length = 250)
    private String method;

    /**
     * 方法参数(JSON字符串)
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "方法参数(JSON字符串)")
    @Column(name = "custom_args", nullable = true)
    private String customArgs;

    /**
     * 定时任务表达式
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "定时任务表达式")
    @Column(name = "cron", nullable = true, length = 200)
    private String cron;

    /**
     * 状态：0禁用；1启用；
     * nullable : true
     * default  : 0
     */
    @ApiModelProperty(value = "状态：0禁用；1启用；")
    @Column(name = "status", nullable = true, length = 11)
    private Integer status;

    /**
     * 实例删除策略
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "实例删除策略")
    @Column(name = "deletion_strategy", nullable = true, length = 2)
    private String deletionStrategy;

    /**
     * 自定义标签
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "自定义标签/分组")
    @Column(name = "tags", nullable = true)
    private String tags;
}
