package com.elitesland.cbpl.scheduling.util;

import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.scheduling.constant.DeletionStrategy;
import com.elitesland.cbpl.scheduling.constant.ScheduleTag;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;

import static com.elitesland.cbpl.scheduling.util.SchedulingUtil.getTaskCode;

/**
 * @author eric.hao
 * @since 2024/05/24
 */
public class SchedulingParamUtil {

    private static final String METHOD_DELETION_KEY = "deletion";

    /**
     * 实例日志 - 定期删除默认参数
     */
    public static ScheduleConfigSaveParamVO deletionParamInit(Class<?> clazz, String taskName, String cron) {
        var saveParam = new ScheduleConfigSaveParamVO();
        saveParam.setTaskCode(getTaskCode(clazz));
        saveParam.setTaskName(taskName);
        saveParam.setClassName(clazz.getName());
        saveParam.setMethod(METHOD_DELETION_KEY);
        saveParam.setCron(cron);
        saveParam.setStatus(ActiveStatus.ACTIVE.getCode());
        saveParam.setDeletionStrategy(DeletionStrategy.DELETION_3.getDays());
        saveParam.setTags(ScheduleTag.SCHEDULE_DELETION_TAG);
        return saveParam;
    }
}
