package com.elitesland.cbpl.scheduling.constant;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.base.EnumValues;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Getter
public enum QueueSolution {

    /**
     * 队列解决方案
     */
    DEFAULT("不启用异步"),
    DISRUPTOR("内存队列"),
    ROCKET_MQ("RocketMQ"),
    KAFKA("Kafka"),
    STREAM("SpringCloud Stream"),
    ;

    private final String desc;

    QueueSolution(String desc) {
        this.desc = desc;
    }

    public String getCode() {
        return name();
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (QueueSolution status : QueueSolution.values()) {
            if (status.getCode().equals(code)) {
                return status.getDesc();
            }
        }
        return "";
    }

    public static List<EnumValues> enumValues() {
        return Arrays.stream(QueueSolution.values())
                .map(name -> EnumValues.of(name.getCode(), name.getDesc()))
                .collect(Collectors.toList());
    }
}
