package com.elitesland.cbpl.scheduling.data.vo.param;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 任务实例
 *
 * @author eric.hao
 * @since 2023/09/12
 */
@Data
@ApiModel("任务实例 - 删除参数")
public class ScheduleInstanceDeleteParamVO {

    @ApiModelProperty(value = "任务编码")
    @NotNull(message = "任务编码必传")
    private String taskCode;

    @ApiModelProperty(value = "实例行状态")
    @NotEmpty(message = "状态必传")
    private List<String> instanceStatus;

    @ApiModelProperty(value = "日期")
    @NotNull(message = "日期必传")
    private LocalDateTime beforeTime;

    /**
     * 所有条件均为空
     */
    public boolean isEmpty() {
        return StrUtil.isBlank(taskCode) && CollUtil.isEmpty(instanceStatus) && ObjectUtil.isNull(beforeTime);
    }
}
