package com.elitesland.cbpl.scheduling.data.vo.param;

import com.elitesland.cbpl.tool.db.PageQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.time.LocalDateTime;

/**
 * 任务实例
 *
 * @author eric.hao
 * @since 2023/09/12
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel("任务实例")
public class ScheduleInstancePagingParamVO extends PageQueryParam {

	private static final long serialVersionUID = 9143848778433796859L;

	@ApiModelProperty(value = "任务编码/名称")
	private String taskCodeName;

	@ApiModelProperty(value = "任务类名")
	private String className;

	@ApiModelProperty(value = "任务方法")
	private String methodName;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "开始时间")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "结束时间")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "自定义标签")
	private String tags;
}
