/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.data.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.data.convert.ScheduleConfigConvert;
import com.elitesland.cbpl.scheduling.data.entity.ScheduleConfigDO;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepo;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleInstanceRepoProc;
import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceDeleteParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.cron.CronPatternUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScheduleConfigServiceImpl
implements ScheduleConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfigServiceImpl.class);
    private final ScheduleConfigRepo scheduleConfigRepo;
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    private final ScheduleInstanceRepoProc scheduleInstanceRepoProc;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    @Override
    public PagingVO<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query) {
        long count = this.scheduleConfigRepoProc.scheduleConfigCountBy(query);
        if (count > 0L) {
            List<ScheduleConfigDO> list = this.scheduleConfigRepoProc.scheduleConfigPageBy(query);
            return new PagingVO(count, ScheduleConfigConvert.INSTANCE.doToPageVO(list));
        }
        return new PagingVO();
    }

    @Override
    public List<ScheduledTask> scheduleConfigByParam(ScheduleConfigQueryParamVO query) {
        List<ScheduleConfigDO> tasks = this.scheduleConfigRepoProc.scheduleConfigByParam(query);
        return tasks.stream().map(row -> ScheduledTask.builder().taskId(row.getId()).taskCode(row.getTaskCode()).taskName(row.getTaskName()).className(row.getClassName()).methodName(row.getMethod()).customArgs(row.getCustomArgs()).cron(row.getCron()).build().createTriggerTask()).collect(Collectors.toList());
    }

    @Override
    public ScheduleConfigDetailVO scheduleConfigById(Long id) {
        Optional scheduleConfigDO = this.scheduleConfigRepo.findById(id);
        if (scheduleConfigDO.isEmpty()) {
            throw PhoenixException.unchecked((String)"Not Found Data");
        }
        return ScheduleConfigConvert.INSTANCE.doToDetailVO((ScheduleConfigDO)scheduleConfigDO.get());
    }

    private ScheduledTask scheduledByTaskId(Long taskId) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigById(taskId);
        return ScheduledTask.builder().taskId(taskId).taskCode(schedule.getTaskCode()).taskName(schedule.getTaskName()).className(schedule.getClassName()).methodName(schedule.getMethod()).customArgs(schedule.getCustomArgs()).cron(schedule.getCron()).build().createTriggerTask();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ScheduleConfigSaveParamVO saveParam) {
        ScheduledTask task = ScheduledTask.builder().taskId(saveParam.getId()).taskCode(saveParam.getTaskCode()).taskName(saveParam.getTaskName()).className(saveParam.getClassName()).methodName(saveParam.getMethod()).customArgs(saveParam.getCustomArgs()).cron(saveParam.getCron()).build().createTriggerTask();
        boolean exists = this.scheduleConfigRepoProc.existsByCode(saveParam.getId(), saveParam.getTaskCode());
        Assert.isFalse((boolean)exists, (String)"\u4efb\u52a1\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (saveParam.isNew()) {
            ScheduleConfigDO scheduleConfigDO = ScheduleConfigConvert.INSTANCE.saveParamToDO(saveParam);
            this.scheduleConfigRepo.save(scheduleConfigDO);
            if (scheduleConfigDO.getStatus().equals(ActiveStatus.ACTIVE.getCode())) {
                this.addTriggerTask(task);
            }
            return scheduleConfigDO.getId();
        }
        Optional scheduleConfigDO = this.scheduleConfigRepo.findById(saveParam.getId());
        if (scheduleConfigDO.isEmpty()) {
            throw PhoenixException.unchecked((String)"Not Found Data");
        }
        ScheduleConfigDO scheduleConfig = (ScheduleConfigDO)scheduleConfigDO.get();
        ScheduleConfigConvert.INSTANCE.saveParamMergeToDO(saveParam, scheduleConfig);
        this.scheduleConfigRepo.save(scheduleConfig);
        if (scheduleConfig.getStatus().equals(ActiveStatus.ACTIVE.getCode())) {
            this.resetTriggerTask(task);
        }
        return scheduleConfig.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void active(Long id) {
        this.scheduleConfigRepoProc.updateStatus(id, ActiveStatus.ACTIVE.getCode());
        this.resetTriggerTask(this.scheduledByTaskId(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void inactive(Long id) {
        this.scheduleConfigRepoProc.updateStatus(id, ActiveStatus.INACTIVE.getCode());
        this.cancelTriggerTask(this.scheduledByTaskId(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(List<Long> ids) {
        ids.stream().map(this::scheduledByTaskId).forEach(this::cancelTriggerTask);
        return this.scheduleConfigRepoProc.updateDeleteFlag(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<Long> ids) {
        ids.stream().map(this::scheduledByTaskId).forEach(this::cancelTriggerTask);
        this.scheduleConfigRepo.deleteAllById(ids);
    }

    @Override
    public void execute(Long taskId) {
        try {
            this.runImmediately(this.scheduledByTaskId(taskId));
        }
        catch (RuntimeException e) {
            throw PhoenixException.unchecked((String)("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] execute once error: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            throw PhoenixException.unchecked((String)"\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
    }

    @Override
    public List<String> preview(Long taskId) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigById(taskId);
        return CronPatternUtils.preview((String)schedule.getCron(), (int)20);
    }

    @Override
    public List<String> previewCron(String cronStr) {
        return CronPatternUtils.preview((String)cronStr, (int)20);
    }

    @Override
    public Set<String> taskCodes() {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            return this.schedulingRegistrar.taskCodes();
        }
        return Collections.emptySet();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long deleteInstance(ScheduleInstanceDeleteParamVO paramVO, String source) {
        if (!paramVO.isEmpty()) {
            logger.debug("[PHOENIX-SCHEDULE] {} delete instance: {}", (Object)source, (Object)BeanUtils.toJsonStr((Object)paramVO));
            return this.scheduleInstanceRepoProc.delete(paramVO);
        }
        return 0L;
    }

    @Override
    public List<String> strategyPreview() {
        return CronPatternUtils.preview((String)SchedulingProperties.SCHEDULE_DELETION_CRON, (int)10);
    }

    @Override
    public boolean stopImmediately(String taskCode) {
        return this.stopImmediately(taskCode, true);
    }

    private void addTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.addTriggerTask(task);
        }
    }

    private void resetTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.resetTriggerTask(task);
        }
    }

    private void cancelTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.cancelTriggerTask(task);
        }
    }

    private void runImmediately(ScheduledTask task) {
        if (ObjectUtil.isNull((Object)this.schedulingRegistrar)) {
            throw new RuntimeException("Phoenix-Schedule\u6a21\u5757\u672a\u5f00\u542f");
        }
        this.schedulingRegistrar.runImmediately(task);
    }

    private boolean stopImmediately(String taskCode, boolean mayInterruptIfRunning) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            return this.schedulingRegistrar.stopImmediately(taskCode, mayInterruptIfRunning);
        }
        return true;
    }

    public ScheduleConfigServiceImpl(ScheduleConfigRepo scheduleConfigRepo, ScheduleConfigRepoProc scheduleConfigRepoProc, ScheduleInstanceRepoProc scheduleInstanceRepoProc) {
        this.scheduleConfigRepo = scheduleConfigRepo;
        this.scheduleConfigRepoProc = scheduleConfigRepoProc;
        this.scheduleInstanceRepoProc = scheduleInstanceRepoProc;
    }
}

