/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar;

import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.registrar.execute.ScheduleExecuteHandler;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.tool.core.util.StringUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class DefaultSchedulingRegistrar
implements SchedulingConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulingRegistrar.class);
    private final ScheduleExecuteHandler scheduleExecuteHandler;
    private ScheduledTaskRegistrar taskRegistrar;
    private final Map<String, ScheduledFuture<?>> taskFutures = new ConcurrentHashMap();
    @Resource
    private ScheduledExecutorService phoenixScheduleTp;

    public void configureTasks(@NotNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.phoenixScheduleTp);
        this.taskRegistrar = taskRegistrar;
    }

    public void runImmediately(ScheduledTask task) {
        this.scheduleExecuteHandler.runImmediately(task);
    }

    public void addTriggerTask(ScheduledTask task) {
        String taskFutureKey = this.taskFutureKey(task.getTaskCode());
        if (this.taskFutures.containsKey(taskFutureKey)) {
            throw new SchedulingException("[PHOENIX-SCHEDULE] taskCode[" + task.getTaskCode() + "] was added.");
        }
        TaskScheduler scheduler = this.taskRegistrar.getScheduler();
        ScheduledFuture future = scheduler.schedule(this.scheduleExecuteHandler.runAuto(task), task.getTriggerTask().getTrigger());
        this.taskFutures.put(taskFutureKey, future);
        logger.info("[PHOENIX-SCHEDULE] add taskCode[{}] success.", (Object)task.getTaskCode());
    }

    public void cancelTriggerTask(ScheduledTask task) {
        if (!this.hasTask(task.getTaskCode())) {
            logger.info("[PHOENIX-SCHEDULE] taskCode[{}] not exist to cancel.", (Object)task.getTaskCode());
            return;
        }
        boolean cancelTag = this.stopImmediately(task.getTaskCode(), false);
        logger.info("[PHOENIX-SCHEDULE] taskCode[{}] canceled {}.", (Object)task.getTaskCode(), (Object)cancelTag);
    }

    public boolean stopTriggerTask(ScheduledTask task) {
        if (!this.hasTask(task.getTaskCode())) {
            logger.warn("[PHOENIX-SCHEDULE] taskCode[{}] not exist to stop.", (Object)task.getTaskCode());
            return true;
        }
        boolean stopTag = this.stopImmediately(task.getTaskCode(), true);
        logger.info("[PHOENIX-SCHEDULE] taskCode[{}] stopped {}.", (Object)task.getTaskCode(), (Object)stopTag);
        return stopTag;
    }

    public boolean stopImmediately(String taskCode, boolean mayInterruptIfRunning) {
        String taskFutureKey = this.taskFutureKey(taskCode);
        ScheduledFuture<?> future = this.taskFutures.get(taskFutureKey);
        boolean cancelTag = future.cancel(mayInterruptIfRunning);
        if (cancelTag) {
            this.taskFutures.remove(taskFutureKey);
        }
        return cancelTag;
    }

    public boolean stopTriggerInstance(Long instanceId) {
        boolean stopTag = this.scheduleExecuteHandler.stopImmediately(instanceId);
        logger.info("[PHOENIX-SCHEDULE] instanceId[{}] stopped {}.", (Object)instanceId, (Object)stopTag);
        return stopTag;
    }

    public void resetTriggerTask(ScheduledTask task) {
        this.cancelTriggerTask(task);
        this.addTriggerTask(task);
    }

    public Set<String> taskCodes() {
        return this.taskFutures.keySet();
    }

    public boolean hasTask(String taskCode) {
        return this.taskFutures.containsKey(this.taskFutureKey(taskCode));
    }

    public boolean initializeCompleted() {
        return this.taskRegistrar != null && this.taskRegistrar.getScheduler() != null;
    }

    private String taskFutureKey(String taskCode) {
        if (SchedulingUtil.noTenant()) {
            return taskCode;
        }
        return StringUtils.tenantKey((String[])new String[]{taskCode});
    }

    public DefaultSchedulingRegistrar(ScheduleExecuteHandler scheduleExecuteHandler) {
        this.scheduleExecuteHandler = scheduleExecuteHandler;
    }
}

