/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar;

import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.spi.ScheduleInitializeSpi;
import com.elitesland.cbpl.scheduling.spi.SchedulingRegistrarSpi;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.util.ReflectUtils;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleInitialize
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleInitialize.class);
    @Autowired(required=false)
    private ScheduleInitializeSpi scheduleInitializeSpi;
    @Resource
    private ScheduleConfigService scheduleConfigService;
    private final DefaultSchedulingRegistrar schedulingRegistrar;

    public void afterPropertiesSet() {
        new Thread(() -> {
            try {
                while (!this.schedulingRegistrar.initializeCompleted()) {
                    Thread.sleep(100L);
                }
                while (this.scheduleInitializeSpi != null && !this.scheduleInitializeSpi.initializeCompleted()) {
                    Thread.sleep(100L);
                }
                ScheduleConfigQueryParamVO query = new ScheduleConfigQueryParamVO();
                query.setStatus(ActiveStatus.ACTIVE.getCode());
                Runnable runnable = () -> {
                    List<ScheduledTask> tasks = this.scheduleConfigService.scheduleConfigByParam(query);
                    tasks.forEach(this.schedulingRegistrar::addTriggerTask);
                    List register = ReflectUtils.getSubTypesOf(SchedulingRegistrarSpi.class);
                    register.stream().filter(SchedulingRegistrarSpi::autoRegister).forEach(row -> {
                        try {
                            ScheduleConfigSaveParamVO saveParam = row.registerTask();
                            if (!this.schedulingRegistrar.hasTask(saveParam.getTaskCode())) {
                                this.scheduleConfigService.save(saveParam);
                            }
                        }
                        catch (Exception e) {
                            logger.error("[PHOENIX-SCHEDULE] Schedule Registrar SPI failed: {}", (Object)ExceptionUtils.formatException((Throwable)e));
                        }
                    });
                };
                if (SchedulingUtil.noTenant()) {
                    runnable.run();
                } else {
                    TenantSpiUtil.byTenants((Runnable)runnable);
                }
            }
            catch (Exception e) {
                logger.error("[PHOENIX-SCHEDULE] schedule initialize failed: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            }
        }).start();
    }

    public ScheduleInitialize(DefaultSchedulingRegistrar schedulingRegistrar) {
        this.schedulingRegistrar = schedulingRegistrar;
    }
}

