package com.elitesland.cbpl.scheduling.data.convert;

import com.elitesland.cbpl.scheduling.data.entity.ScheduleInstanceDO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceRespVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2023/09/12
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScheduleInstanceConvert {

    ScheduleInstanceConvert INSTANCE = Mappers.getMapper(ScheduleInstanceConvert.class);

    /**
     * DO => RespVO
     */
    ScheduleInstanceDetailVO doToVO(ScheduleInstanceDO scheduleInstanceDO);

    /**
     * SaveParam => DO
     */
    ScheduleInstanceDO saveParamToDO(ScheduleInstanceSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(ScheduleInstanceSaveParamVO saveParam, @MappingTarget ScheduleInstanceDO scheduleInstanceDO);

    /**
     * SaveParam => RespVO
     */
    ScheduleInstanceRespVO saveParamToVO(ScheduleInstanceSaveParamVO instance);

    /**
     * RespVO => DetailVO
     */
    ScheduleInstanceDetailVO respToVO(ScheduleInstanceRespVO respVO);
}
