package com.elitesland.cbpl.scheduling.data.vo.param;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.scheduling.constant.ScheduleTag;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 定时任务配置表
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ApiModel("定时任务配置表")
public class ScheduleConfigSaveParamVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "定时任务名称")
	@NotBlank(message = "任务名称必填")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	@NotBlank(message = "任务编码必填")
	private String taskCode;

	@ApiModelProperty(value = "类名")
	@NotBlank(message = "类名必填")
	private String className;

	@ApiModelProperty(value = "方法名")
	@NotBlank(message = "方法名必填")
	private String method;

	@ApiModelProperty(value = "方法参数")
	private String customArgs;

	@ApiModelProperty(value = "定时任务表达式")
	@NotBlank(message = "任务表达式必填")
	private String cron;

	@ApiModelProperty(value = "状态：0禁用；1启用；")
	private Integer status;

	@ApiModelProperty(value = "实例删除策略")
	private String deletionStrategy;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "自定义标签")
	private String tags = ScheduleTag.SCHEDULE_BUSINESS_TAG;

	public boolean isNew() {
		return ObjectUtil.isNull(id);
	}
}
