/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.config;

import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.queue.producer.DefaultQueueProducer;
import com.elitesland.cbpl.scheduling.queue.producer.ScheduleQueueProducer;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.ScheduleInitialize;
import com.elitesland.cbpl.scheduling.registrar.execute.ScheduleExecuteHandler;
import com.elitesland.cbpl.scheduling.registrar.task.InstanceDeletionTask;
import java.util.concurrent.ScheduledExecutorService;
import org.dromara.dynamictp.core.spring.EnableDynamicTp;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@EnableDynamicTp
@Configuration
@EnableConfigurationProperties(value={SchedulingProperties.class})
@ConditionalOnProperty(prefix="cbpl.schedule", name={"enabled"}, havingValue="true")
public class SchedulingAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="cbpl.schedule", name={"queue-solution"}, havingValue="default", matchIfMissing=true)
    public ScheduleQueueProducer scheduleQueueProducer() {
        logger.info("[PHOENIX-SCHEDULE] Registry DefaultQueueProducer.");
        return new DefaultQueueProducer();
    }

    @Bean
    public ScheduleExecuteHandler scheduleExecuteHandler() {
        return new ScheduleExecuteHandler();
    }

    @Bean
    public DefaultSchedulingRegistrar defaultSchedulingRegistrar(ScheduleExecuteHandler scheduleExecuteHandler) {
        logger.info("[PHOENIX-SCHEDULE] Scheduling enabled.");
        return new DefaultSchedulingRegistrar(scheduleExecuteHandler);
    }

    @Bean
    public ScheduleInitialize scheduleInitialize(DefaultSchedulingRegistrar schedulingRegistrar) {
        ScheduleInitialize schedule = new ScheduleInitialize(schedulingRegistrar);
        logger.info("[PHOENIX-SCHEDULE] Initialize finished.");
        return schedule;
    }

    @Bean
    @ConditionalOnClass
    public InstanceDeletionTask instanceDeletionTask(ScheduleConfigService scheduleConfigService, ScheduleConfigRepoProc scheduleConfigRepoProc) {
        return new InstanceDeletionTask(scheduleConfigService, scheduleConfigRepoProc);
    }

    @Bean(value={"phoenixScheduleTp"})
    public ScheduledExecutorService phoenixScheduleTp(SchedulingProperties properties) {
        return ThreadPoolBuilder.newBuilder().threadPoolName("phoenixScheduleTp").threadFactory("phoenix-schedule-tp").corePoolSize(properties.getCorePoolSize()).maximumPoolSize(properties.getMaximumPoolSize()).queueCapacity(properties.getQueueCapacity()).rejectedExecutionHandler(properties.getRejectPolicy()).buildScheduled();
    }
}

