/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.scheduling.data.entity.QScheduleConfigDO;
import com.elitesland.cbpl.scheduling.data.entity.ScheduleConfigDO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScheduleConfigRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScheduleConfigDO scheduleConfigDO = QScheduleConfigDO.scheduleConfigDO;

    private Predicate pagingWhere(ScheduleConfigPagingParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getTaskCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskCodeName());
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCodeName()).or((Predicate)ScheduleConfigRepoProc.scheduleConfigDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskName());
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskName.like(likeStr));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getClassName())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.className.eq((Object)query.getClassName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getMethod())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.method.eq((Object)query.getMethod()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCron())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.cron.eq((Object)query.getCron()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStatus())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.status.eq((Object)query.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.remark.eq((Object)query.getRemark()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTags())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.tags.eq((Object)query.getTags()));
        } else {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.tags.eq((Object)"ST_BUSINESS").or((Predicate)ScheduleConfigRepoProc.scheduleConfigDO.tags.isNull()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long scheduleConfigCountBy(ScheduleConfigPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(ScheduleConfigRepoProc.scheduleConfigDO.id).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<ScheduleConfigDO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)scheduleConfigDO).from((EntityPath)scheduleConfigDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, scheduleConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private Predicate where(ScheduleConfigQueryParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)0));
        if (StrUtil.isNotBlank((CharSequence)query.getTaskName())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskName.eq((Object)query.getTaskName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStatus())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.status.eq((Object)query.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTags())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.tags.eq((Object)query.getTags()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScheduleConfigDO> scheduleConfigByParam(ScheduleConfigQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)scheduleConfigDO).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scheduleConfigDO).set(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag, (Object)1).where(new Predicate[]{ScheduleConfigRepoProc.scheduleConfigDO.id.in(ids)});
        return update.execute();
    }

    public long updateStatus(Long id, int status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scheduleConfigDO).set(ScheduleConfigRepoProc.scheduleConfigDO.status, (Object)status).where(new Predicate[]{ScheduleConfigRepoProc.scheduleConfigDO.id.eq((Object)id)});
        return update.execute();
    }

    public boolean existsByCode(Long taskId, String taskCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)taskCode));
        if (ObjectUtil.isNotNull((Object)taskId)) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.id.ne((Object)taskId));
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(ScheduleConfigRepoProc.scheduleConfigDO.id).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return !jpaQuery.fetch().isEmpty();
    }

    public ScheduleConfigRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

