/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar.execute;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.logging.common.util.LogTraceUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.scheduling.constant.InstanceStatus;
import com.elitesland.cbpl.scheduling.data.convert.ScheduleInstanceConvert;
import com.elitesland.cbpl.scheduling.data.service.ScheduleInstanceService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceRespVO;
import com.elitesland.cbpl.scheduling.queue.producer.ScheduleQueueProducer;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.spi.ScheduleCompleteProvider;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.util.StringUtils;
import com.elitesland.cbpl.tool.tenant.TenantClientSpi;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.lzhpo.tracer.util.TracerUtils;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleExecuteHandler.class);
    @Resource
    private ScheduleInstanceService scheduleInstanceService;
    @Autowired(required=false)
    private ScheduleQueueProducer scheduleQueueProducer;
    @Autowired(required=false)
    private ScheduleCompleteProvider scheduleCompleteProvider;
    @Autowired(required=false)
    private TenantClientSpi tenantClientSpi;
    private final Map<String, CompletableFuture<?>> instanceFutures = new ConcurrentHashMap();

    public Runnable runAuto(ScheduledTask task) {
        Runnable executor = () -> this.runImmediately(task, "\u81ea\u52a8\u6267\u884c");
        if (SchedulingUtil.noTenant()) {
            return RunnableWrapper.of((Runnable)executor);
        }
        String tenantCode = TenantSpiUtil.currentTenantCode();
        return RunnableWrapper.of(() -> this.tenantClientSpi.byTenantDirectly(executor, tenantCode));
    }

    public void runImmediately(ScheduledTask task) {
        this.runImmediately(task, "\u624b\u52a8\u6267\u884c");
    }

    public Long runImmediately(ScheduledTask task, String runType) {
        ScheduleInstanceSaveParamVO instance = this.instanceLog(task, runType);
        this.scheduleQueueProducer.send(instance, task.getTriggerTask().getRunnable());
        return instance.getId();
    }

    private ScheduleInstanceSaveParamVO instanceLog(ScheduledTask task, String runType) {
        ScheduleInstanceSaveParamVO saveParam = new ScheduleInstanceSaveParamVO();
        saveParam.setMasId(task.getTaskId());
        saveParam.setTaskCode(task.getTaskCode());
        saveParam.setTaskName(task.getTaskName());
        saveParam.setStartTime(LocalDateTime.now());
        saveParam.setInstanceStatus(InstanceStatus.READY.getCode());
        saveParam.setRemark(runType);
        Long instanceId = this.scheduleInstanceService.save(saveParam);
        saveParam.setId(instanceId);
        return saveParam;
    }

    public void execute(ScheduleInstanceSaveParamVO instance, Runnable runnable) {
        LogTraceUtil.initTraceId();
        LogUtil.info((String)("[CRON][TaskCode] " + instance.getTaskCode() + " \u5f00\u59cb\u6267\u884c:"));
        try {
            if (this.scheduleCompleteProvider != null) {
                ScheduleInstanceRespVO response = ScheduleInstanceConvert.INSTANCE.saveParamToVO(instance);
                this.scheduleCompleteProvider.start(response);
            }
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] execute complete start error.", (Throwable)e);
        }
        Exception throwable = null;
        try {
            instance.setTraceId(TracerUtils.getTraceId());
            instance.setInstanceStatus(InstanceStatus.RUNNING.getCode());
            instance.setExecuteTime(LocalDateTime.now());
            this.scheduleInstanceService.update(instance);
            instance.setInstanceStatus(InstanceStatus.COMPLETE.getCode());
            runnable.run();
        }
        catch (Exception e) {
            throwable = e;
            instance.setInstanceStatus(InstanceStatus.INTERRUPT.getCode());
            instance.setErrorMessage(ExceptionUtils.formatException((Throwable)e, (int)255));
            LogUtil.error((String)"[CRON] \u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        instance.setEndTime(LocalDateTime.now());
        this.scheduleInstanceService.update(instance);
        LogUtil.info((String)("[CRON][TaskCode] " + instance.getTaskCode() + " \u6267\u884c\u7ed3\u675f."));
        try {
            if (this.scheduleCompleteProvider != null) {
                ScheduleInstanceRespVO response = ScheduleInstanceConvert.INSTANCE.saveParamToVO(instance);
                this.scheduleCompleteProvider.whenComplete(response, throwable);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"[CRON] \u5b9e\u4f8b\u6267\u884c\u5b8c\u540e\u7684\u56de\u8c03\u65b9\u6cd5\uff0c\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        LogTraceUtil.clearTraceId();
    }

    public boolean stopImmediately(Long instanceId) {
        try {
            String instanceFutureKey = this.instanceFutureKey(instanceId);
            CompletableFuture<?> future = this.instanceFutures.get(instanceFutureKey);
            if (ObjectUtil.isEmpty(future)) {
                return true;
            }
            boolean stopTag = future.cancel(true);
            ScheduleInstanceDetailVO instance = this.scheduleInstanceService.scheduleInstanceById(instanceId);
            ScheduleInstanceSaveParamVO saveParam = new ScheduleInstanceSaveParamVO();
            saveParam.setId(instanceId);
            saveParam.setEndTime(LocalDateTime.now());
            if (stopTag) {
                this.instanceFutures.remove(instanceFutureKey);
                saveParam.setInstanceStatus(InstanceStatus.STOP.getCode());
            }
            saveParam.setRemark(instance.getRemark() + "\uff1b\u624b\u52a8\u7ec8\u6b62\uff0c\u662f\u5426\u7ec8\u6b62\u6210\u529f\uff1a" + stopTag + "\uff1b");
            this.scheduleInstanceService.update(saveParam);
            return stopTag;
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] stop immediately unexpected error.", (Throwable)e);
            return false;
        }
    }

    private String instanceFutureKey(Long instanceId) {
        if (SchedulingUtil.noTenant()) {
            return String.valueOf(instanceId);
        }
        return StringUtils.tenantKey((String[])new String[]{String.valueOf(instanceId)});
    }
}

