package com.elitesland.cbpl.scheduling.data.vo.resp;

import com.elitesland.cbpl.scheduling.constant.InstanceStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务实例
 *
 * @author eric.hao
 * @since 2023/09/12
 */
@Data
@ApiModel("任务实例")
public class ScheduleInstanceDetailVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "任务ID")
	private Long masId;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@ApiModelProperty(value = "日志行状态中文")
	private String instanceStatusName;

	@JsonProperty
	public String getInstanceStatusName() {
		return InstanceStatus.fromCode(instanceStatus);
	}

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "开始时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "结束时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "备注")
	private String remark;
}
